/* ================================================
   Perfex + Admin Flat — RTL Fix Pack (Unified JS)
   ================================================ */
(function () {
  // ——— 0) كشف اللغة وتثبيت RTL ———
  var lang = (document.documentElement.getAttribute('lang') || '').toLowerCase();
  var appLocale = (window.app && app.locale) ? String(app.locale).toLowerCase() : '';
  var isRTL = /^(ar|fa|ur)/.test(lang) || /^(ar|fa|ur)/.test(appLocale) || document.documentElement.dir === 'rtl';

  if (!isRTL) return;
  document.documentElement.setAttribute('dir', 'rtl');
  document.body.classList.add('rtl');

  // Helper: DOM ready
  function onReady(fn){ if (document.readyState !== 'loading') fn(); else document.addEventListener('DOMContentLoaded', fn); }

  onReady(function () {
    var $ = window.jQuery || window.$;

    /* ——— 1) تهيئة الإضافات الشائعة على RTL ——— */
    // Select2
    if ($ && $.fn && $.fn.select2) {
      try {
        $.fn.select2.defaults.set('dir', 'rtl');
        $('.select2, select[data-toggle="select2"]').each(function () {
          var $el = $(this);
          if ($el.data('select2')) $el.select2('destroy');
          $el.attr('dir', 'rtl').select2({ dir: 'rtl', width: 'resolve' });
        });
      } catch (e) {}
    }
    // Datepicker
    if ($ && $.fn && $.fn.datepicker) {
      $('.datepicker, .input-group.date').each(function () {
        try { $(this).datepicker('destroy'); } catch (e) {}
        $(this).datepicker({ rtl: true, todayHighlight: true, autoclose: true });
      });
    }
    // DataTables (لغة فقط إن متاح)
    if ($ && $.fn && $.fn.dataTable) {
      $.extend(true, $.fn.dataTable.defaults, {
        // language: { url: (window.app && app.base_url ? app.base_url : '/') + 'modules/arabic/datatable.ar.json' }
      });
    }
    // Summernote
    if ($ && $.fn && $.fn.summernote) {
      $('.summernote').each(function () {
        try { $(this).summernote('destroy'); } catch (e) {}
        $(this).summernote({
          dialogsInBody: true,
          height: 180
          // ,lang: 'ar-AR'
        });
      });
    }
    // Tooltips / Popovers
    if ($) {
      $('[data-toggle="tooltip"],[data-bs-toggle="tooltip"]').tooltip({ container: 'body' });
      $('[data-toggle="popover"],[data-bs-toggle="popover"]').popover({ container: 'body' });
    }

    // Dropdown placement افتراضي يمين
    document.querySelectorAll('.dropdown-menu').forEach(function (m) {
      if (!m.getAttribute('x-placement')) m.setAttribute('x-placement', 'bottom-end');
    });

    // منع overflow في المودالات (خصوصاً شاشة الشعار)
    var fixes = document.createElement('style');
    fixes.innerHTML = `
      html[dir="rtl"] .modal .modal-body { overflow-x: hidden; }
      html[dir="rtl"] .modal .img-fluid, 
      html[dir="rtl"] .modal img { max-width: 100%; height: auto; }
    `;
    document.head.appendChild(fixes);

    /* ——— 2) توب ناف من اليمين لليسار بدون اختفاء أيقونات ——— */
    var navbar = document.querySelector('.main-header .navbar');
    if (navbar) {
      navbar.style.display = 'flex';
      navbar.style.alignItems = 'center';
      navbar.style.flexWrap = 'nowrap';
      navbar.style.flexDirection = 'row-reverse';
      navbar.style.overflow = 'visible';

      var navRight = document.querySelector('.main-header .navbar .navbar-custom-menu, .main-header .navbar .navbar-right');
      if (navRight) {
        navRight.style.order = '2';
        navRight.style.margin = '0';
        navRight.style.flex = '0 0 auto';
        var list = navRight.querySelector('.navbar-nav');
        if (list) {
          list.style.display = 'flex';
          list.style.flexDirection = 'row-reverse';
          list.style.alignItems = 'center';
          list.style.gap = '6px';
        }
      }

      var searchWrap = document.querySelector('.main-header .navbar .navbar-form, .main-header .navbar .nav > li.search, .main-header .navbar .header-search');
      if (searchWrap) {
        searchWrap.style.order = '1';
        searchWrap.style.flex = '1 1 auto';
        searchWrap.style.minWidth = '220px';
        searchWrap.style.margin = '0 10px';
        var sInput = searchWrap.querySelector('input[type="search"]');
        if (sInput && !sInput.getAttribute('placeholder')) sInput.setAttribute('placeholder', '...بحث');
        if (sInput) sInput.style.width = '100%';
      }

      var toggler = document.querySelector('.main-header .navbar .sidebar-toggle');
      if (toggler) {
        toggler.style.order = '0';
        toggler.style.marginRight = '8px';
        toggler.style.marginLeft = '0';
      }
    }

    /* ——— 3) السايدبار: أيقونة يمين | نص | سهم شمال ——— */
    // اجبر السهم أن يكون angle-left في RTL
    document.querySelectorAll('.sidebar-menu li.treeview > a .pull-right-container i').forEach(function (ic) {
      if (ic.classList.contains('fa-angle-right')) {
        ic.classList.remove('fa-angle-right');
        ic.classList.add('fa-angle-left');
      }
    });

    // أعِد ترتيب محتوى عناصر المينيو بصرف النظر عن DOM
    document.querySelectorAll('.sidebar-menu > li > a').forEach(function (a) {
      a.style.display = 'grid';
      a.style.gridTemplateColumns = 'auto 1fr auto'; // ICON | LABEL | ARROW
      a.style.alignItems = 'center';
      a.style.columnGap = '.6rem';

      var icon = a.querySelector('i, svg');
      var label = a.querySelector('span');
      var arrow = a.querySelector('.pull-right-container, .menu-arrow, i.fa-angle-left, i.fa-angle-right');

      if (icon) { icon.style.order = '0'; icon.style.margin = '0'; icon.style.float = 'none'; }
      if (label) { label.style.order = '1'; label.style.whiteSpace = 'nowrap'; label.style.float = 'none'; }
      if (arrow) {
        arrow.style.order = '2';
        arrow.style.justifySelf = 'start';
        arrow.style.right = 'auto';
        arrow.style.left = '8px';
        arrow.style.float = 'none';
      }
    });

    /* ——— 4) الهوامش عند تثبيت السايدبار يمين ——— */
    function getSidebarWidth() {
      var sb = document.querySelector('.main-sidebar, .left-side, .sidebar');
      if (!sb) return 240;
      var w = parseFloat(getComputedStyle(sb).width);
      return (isNaN(w) || w === 0) ? 240 : Math.round(w);
    }

    function applyMargins() {
      var body = document.body;
      var isCollapsed = body.classList.contains('sidebar-collapse');
      var isMini = body.classList.contains('sidebar-mini') && isCollapsed;
      var isOpen = body.classList.contains('sidebar-open'); // موبايل
      var sbw = getSidebarWidth(), miniW = 60;

      document.querySelectorAll('.content-wrapper, .main-footer, .main-header .navbar').forEach(function (el) {
        if (window.matchMedia('(max-width: 767.98px)').matches) {
          el.style.marginRight = isOpen ? sbw + 'px' : 0;
        } else if (isMini) {
          el.style.marginRight = miniW + 'px';
        } else if (isCollapsed) {
          el.style.marginRight = 0;
        } else {
          el.style.marginRight = sbw + 'px';
        }
        el.style.marginLeft = 0;
      });
    }

    applyMargins();
    window.addEventListener('resize', applyMargins);

    var obs = new MutationObserver(applyMargins);
    obs.observe(document.body, { attributes: true, attributeFilter: ['class'] });

    document.addEventListener('click', function (e) {
      if (e.target.closest('[data-toggle="push-menu"], .sidebar-toggle')) {
        setTimeout(applyMargins, 310);
      }
    });
  });
})();
