<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to Smart School Event!</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f0f4f8; /* Fallback background color */
            background-image: url('https://drive.google.com/file/d/1xZ_KM72fxy4qAxZcJ7rcx33_49QmHY_T/view?usp=sharing'); /* Updated background image URL. Note: Google Drive links may not work directly as image sources without specific sharing settings or public hosting. */
            background-size: cover; /* Cover the entire viewport */
            background-position: center; /* Center the background image */
            background-repeat: no-repeat; /* Do not repeat the background image */
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            padding: 20px;
            box-sizing: border-box;
            position: relative; /* Needed for overlay */
        }
        /* Optional: Add an overlay for better text readability on busy backgrounds */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.3); /* Semi-transparent black overlay */
            z-index: 0; /* Ensure it's behind the content container */
        }
        .container {
            /* Re-added semi-transparent background color for better text readability */
            background-color: rgba(255, 255, 255, 0.8); /* Semi-transparent white card background */
            background-image: url('https://connectionseg.com/event/7xm686e582d47114.jpg'); /* Updated background image for container */
            background-size: cover; /* Make the background image cover the container */
            background-repeat: no-repeat; /* Do not repeat the background image */
            background-position: center; /* Center the background image */
            border-radius: 20px; /* More rounded corners */
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1); /* Softer shadow */
            padding: 40px;
            text-align: center;
            max-width: 600px;
            width: 100%;
            position: relative; /* Ensure container is above the overlay */
            z-index: 1;
        }
        .button-group {
            display: flex;
            flex-direction: column; /* Stack buttons on small screens */
            gap: 20px; /* Space between buttons */
            margin-top: 30px;
        }
        .button-group a {
            display: inline-block;
            padding: 15px 30px;
            border-radius: 15px; /* Rounded buttons */
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1); /* Button shadow */
        }
        .button-primary {
            background-color: #4f46e5; /* Indigo */
            color: #ffffff;
        }
        .button-primary:hover {
            background-color: #4338ca; /* Darker indigo on hover */
            transform: translateY(-3px); /* Slight lift effect */
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
        }
        .button-secondary {
            background-color: #22c55e; /* Green */
            color: #ffffff;
        }
        .button-secondary:hover {
            background-color: #16a34a; /* Darker green on hover */
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
        }
        .language-switcher {
            margin-bottom: 20px;
            display: flex;
            justify-content: center;
            gap: 10px;
        }
        .language-switcher button {
            padding: 8px 15px;
            border-radius: 10px;
            background-color: #e2e8f0; /* Light gray */
            color: #4a5568; /* Dark gray text */
            font-weight: 600;
            border: none;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .language-switcher button.active {
            background-color: #cbd5e0; /* Slightly darker gray when active */
            color: #2d3748;
        }
        .language-switcher button:hover {
            background-color: #cbd5e0;
        }

        /* Responsive adjustments */
        @media (min-width: 640px) {
            .button-group {
                flex-direction: row; /* Buttons side-by-side on larger screens */
                justify-content: center;
            }
        }
    </style>
</head>

<body dir="ltr">
    <div class="container">
        
        <img id="main-header-image" src="https://connectionseg.com/event/Image-2 .jpeg" alt="Main Header Image" class="w-full mx-auto rounded-lg shadow-md mb-8">
        
        <div class="language-switcher">
            <button id="lang-en" class="active">English</button>
            <button id="lang-ar">العربية</button>
        </div>

        <img id="secondary-image" src="https://connectionseg.com/event/point-2.png" alt="Secondary Image" class="w-1/2 mx-auto rounded-lg shadow-md mb-8">

        <h1 id="main-title" class="text-4xl font-bold text-white mb-4">Welcome!</h1>
        <p id="main-paragraph" class="text-lg text-white mb-8">
            We're excited to have you here. Please use the options below to get started.
        </p>

        <div class="button-group">
            <a id="form-button" href="https://docs.google.com/forms/d/e/1FAIpQLSduuE351bFAGiBMZA8iZJ9cu-uB81GQu5iQgP9v81pIee1dLQ/viewform" target="_blank" class="button-primary">
                Fill Registration Form
            </a>
            <a id="directions-button" href="https://maps.app.goo.gl/f9GB9ymVhW2Ukg4z8" target="_blank" class="button-secondary">
                Get Directions
            </a>
            <a id="more-button" href="https://connectionseg.com/event/event-info" target="_blank" class="button-primary">
                More Info
            </a>
        </div>
    </div>

    <script>
        // Object to store translations
        const translations = {
            en: {
                title: "Welcome!",
                paragraph: "We're excited to have you here. Please use the options below to get started.",
                formButton: "Fill Registration Form",
                directionsButton: "Get Directions",
                moreButton: "More Info", // Added translation for More Info button
                formLink: "https://docs.google.com/forms/d/e/1FAIpQLSduuE351bFAGiBMZA8iZJ9cu-uB81GQu5iQgP9v81pIee1dLQ/viewform", // English Google Form link
                moreLink: "https://connectionseg.com/event/event-info/index.html" // Arabic More Info link
            },
            ar: {
                title: "أهلاً وسهلاً!",
                paragraph: "يسعدنا وجودك هنا. يرجى استخدام الخيارات أدناه للبدء.",
                formButton: "املأ نموذج تأكيد الحضور",
                directionsButton: "احصل على الاتجاهات",
                moreButton: "تفاصيل الحدث", // Already present for Arabic
                formLink: "https://docs.google.com/forms/d/1r_I5tJwqcb_0yKo7VgLrhKMR2BlpYSIZ4pd7EN1EHGE/preview", // Arabic Google Form link updated
                moreLink: "https://connectionseg.com/event/event-info/index-ar.html" // Arabic More Info link
            }
        };

        const mainTitle = document.getElementById('main-title');
        const mainParagraph = document.getElementById('main-paragraph');
        const formButton = document.getElementById('form-button');
        const directionsButton = document.getElementById('directions-button');
        const moreButton = document.getElementById('more-button'); // Get the more-button element
        const langEnButton = document.getElementById('lang-en');
        const langArButton = document.getElementById('lang-ar');
        const body = document.body;
        const mainHeaderImage = document.getElementById('main-header-image');
        const secondaryImage = document.getElementById('secondary-image'); 

   // Function to update content based on language
function updateContent(lang) {
    mainTitle.textContent = translations[lang].title;
    mainParagraph.textContent = translations[lang].paragraph;
    formButton.textContent = translations[lang].formButton;
    directionsButton.textContent = translations[lang].directionsButton;
    moreButton.textContent = translations[lang].moreButton; // Update the more-button text
    formButton.href = translations[lang].formLink; // Update the form button's link
    moreButton.href = translations[lang].moreLink; // <--- ADD THIS LINE

    // Set text direction (RTL for Arabic, LTR for English)
    body.dir = lang === 'ar' ? 'rtl' : 'ltr';

    // Update active button styling
    langEnButton.classList.remove('active');
    langArButton.classList.remove('active');
    if (lang === 'en') {
        langEnButton.classList.add('active');
    } else {
        langArButton.classList.add('active');
    }
}
        // Event listeners for language buttons
        langEnButton.addEventListener('click', () => updateContent('en'));
        langArButton.addEventListener('click', () => updateContent('ar'));

        // Set initial content to English
        updateContent('en');
    </script>
</body>
</html>