<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Proxy\V1\Service;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class SessionOptions {
    /**
     * @param string $uniqueName An application-defined string that uniquely
     *                           identifies the resource
     * @param \DateTime $dateExpiry The ISO 8601 date when the Session should expire
     * @param int $ttl When the session will expire
     * @param string $mode The Mode of the Session
     * @param string $status Session status
     * @param array[] $participants The Participant objects to include in the new
     *                              session
     * @return CreateSessionOptions Options builder
     */
    public static function create(string $uniqueName = Values::NONE, \DateTime $dateExpiry = Values::NONE, int $ttl = Values::NONE, string $mode = Values::NONE, string $status = Values::NONE, array $participants = Values::ARRAY_NONE): CreateSessionOptions {
        return new CreateSessionOptions($uniqueName, $dateExpiry, $ttl, $mode, $status, $participants);
    }

    /**
     * @param \DateTime $dateExpiry The ISO 8601 date when the Session should expire
     * @param int $ttl When the session will expire
     * @param string $status The new status of the resource
     * @param bool $failOnParticipantConflict Opt-in to enable Proxy to return 400
     *                                        on detected conflict on re-open
     *                                        request.
     * @return UpdateSessionOptions Options builder
     */
    public static function update(\DateTime $dateExpiry = Values::NONE, int $ttl = Values::NONE, string $status = Values::NONE, bool $failOnParticipantConflict = Values::NONE): UpdateSessionOptions {
        return new UpdateSessionOptions($dateExpiry, $ttl, $status, $failOnParticipantConflict);
    }
}

class CreateSessionOptions extends Options {
    /**
     * @param string $uniqueName An application-defined string that uniquely
     *                           identifies the resource
     * @param \DateTime $dateExpiry The ISO 8601 date when the Session should expire
     * @param int $ttl When the session will expire
     * @param string $mode The Mode of the Session
     * @param string $status Session status
     * @param array[] $participants The Participant objects to include in the new
     *                              session
     */
    public function __construct(string $uniqueName = Values::NONE, \DateTime $dateExpiry = Values::NONE, int $ttl = Values::NONE, string $mode = Values::NONE, string $status = Values::NONE, array $participants = Values::ARRAY_NONE) {
        $this->options['uniqueName'] = $uniqueName;
        $this->options['dateExpiry'] = $dateExpiry;
        $this->options['ttl'] = $ttl;
        $this->options['mode'] = $mode;
        $this->options['status'] = $status;
        $this->options['participants'] = $participants;
    }

    /**
     * An application-defined string that uniquely identifies the resource. This value must be 191 characters or fewer in length and be unique. **This value should not have PII.**
     *
     * @param string $uniqueName An application-defined string that uniquely
     *                           identifies the resource
     * @return $this Fluent Builder
     */
    public function setUniqueName(string $uniqueName): self {
        $this->options['uniqueName'] = $uniqueName;
        return $this;
    }

    /**
     * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date when the Session should expire. If this is value is present, it overrides the `ttl` value.
     *
     * @param \DateTime $dateExpiry The ISO 8601 date when the Session should expire
     * @return $this Fluent Builder
     */
    public function setDateExpiry(\DateTime $dateExpiry): self {
        $this->options['dateExpiry'] = $dateExpiry;
        return $this;
    }

    /**
     * The time, in seconds, when the session will expire. The time is measured from the last Session create or the Session's last Interaction.
     *
     * @param int $ttl When the session will expire
     * @return $this Fluent Builder
     */
    public function setTtl(int $ttl): self {
        $this->options['ttl'] = $ttl;
        return $this;
    }

    /**
     * The Mode of the Session. Can be: `message-only`, `voice-only`, or `voice-and-message` and the default value is `voice-and-message`.
     *
     * @param string $mode The Mode of the Session
     * @return $this Fluent Builder
     */
    public function setMode(string $mode): self {
        $this->options['mode'] = $mode;
        return $this;
    }

    /**
     * The initial status of the Session. Can be: `open`, `in-progress`, `closed`, `failed`, or `unknown`. The default is `open` on create.
     *
     * @param string $status Session status
     * @return $this Fluent Builder
     */
    public function setStatus(string $status): self {
        $this->options['status'] = $status;
        return $this;
    }

    /**
     * The Participant objects to include in the new session.
     *
     * @param array[] $participants The Participant objects to include in the new
     *                              session
     * @return $this Fluent Builder
     */
    public function setParticipants(array $participants): self {
        $this->options['participants'] = $participants;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Proxy.V1.CreateSessionOptions ' . $options . ']';
    }
}

class UpdateSessionOptions extends Options {
    /**
     * @param \DateTime $dateExpiry The ISO 8601 date when the Session should expire
     * @param int $ttl When the session will expire
     * @param string $status The new status of the resource
     * @param bool $failOnParticipantConflict Opt-in to enable Proxy to return 400
     *                                        on detected conflict on re-open
     *                                        request.
     */
    public function __construct(\DateTime $dateExpiry = Values::NONE, int $ttl = Values::NONE, string $status = Values::NONE, bool $failOnParticipantConflict = Values::NONE) {
        $this->options['dateExpiry'] = $dateExpiry;
        $this->options['ttl'] = $ttl;
        $this->options['status'] = $status;
        $this->options['failOnParticipantConflict'] = $failOnParticipantConflict;
    }

    /**
     * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date when the Session should expire. If this is value is present, it overrides the `ttl` value.
     *
     * @param \DateTime $dateExpiry The ISO 8601 date when the Session should expire
     * @return $this Fluent Builder
     */
    public function setDateExpiry(\DateTime $dateExpiry): self {
        $this->options['dateExpiry'] = $dateExpiry;
        return $this;
    }

    /**
     * The time, in seconds, when the session will expire. The time is measured from the last Session create or the Session's last Interaction.
     *
     * @param int $ttl When the session will expire
     * @return $this Fluent Builder
     */
    public function setTtl(int $ttl): self {
        $this->options['ttl'] = $ttl;
        return $this;
    }

    /**
     * The new status of the resource. Can be: `in-progress` to re-open a session or `closed` to close a session.
     *
     * @param string $status The new status of the resource
     * @return $this Fluent Builder
     */
    public function setStatus(string $status): self {
        $this->options['status'] = $status;
        return $this;
    }

    /**
     * Setting to true (recommended), enables Proxy to return a 400 error (Twilio error code 80604) when a request to set a Session to in-progress would cause Participants with the same identifier/proxy_identifier pair to be active in multiple Sessions. If not provided, or if set to false, requests will be allowed to succeed and a Debugger event (80801) will be emitted. This causes calls and messages from affected Participants to be routed incorrectly. Please note, in a future release, the default behavior will be to reject the request with a 400 error.
     *
     * @param bool $failOnParticipantConflict Opt-in to enable Proxy to return 400
     *                                        on detected conflict on re-open
     *                                        request.
     * @return $this Fluent Builder
     */
    public function setFailOnParticipantConflict(bool $failOnParticipantConflict): self {
        $this->options['failOnParticipantConflict'] = $failOnParticipantConflict;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Proxy.V1.UpdateSessionOptions ' . $options . ']';
    }
}