<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Top 10 customer payment
  Description: Top 10 customer payment
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ المدخلات كما هي (قد تكون فاضية)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // دالة بارس آمنة ترجع DateTime حتى لو المدخل null/فاضي
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) {
                return $dt;
            }
        }
        return new DateTime($fallbackSpec);
    };

    // Defaults: من أول يوم في الشهر الحالي إلى آخره
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تأكيد الترتيب لو المستخدم عكسهم
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // استعلام آمن مع Bindings
    $sql = "
        SELECT
            COALESCE(NULLIF(c.company, ''), CONCAT('#', c.userid)) AS company,
            c.userid                                             AS userid,
            IFNULL(SUM(p.amount), 0)                             AS totalpayment
        FROM " . db_prefix() . "invoices i
        INNER JOIN " . db_prefix() . "clients c
                ON i.clientid = c.userid
        INNER JOIN " . db_prefix() . "invoicepaymentrecords p
                ON i.id = p.invoiceid
        WHERE p.date >= ?
          AND p.date <= ?
        GROUP BY c.userid, company
        ORDER BY totalpayment DESC
        LIMIT 10
    ";

    return $CI->db->query($sql, [$from_sql, $to_sql])->result_array();
};

$widget_data = $fn_get_data();
?>

<div class="widget widget-top-10-customer-payment widget-<?= html_escape($widget['id']) ?>" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="">
    <div class="panel_s user-data">
      <div class="panel-body custom-dashboard-panel">
        <div class="widget-dragger"></div>
        <h4 class="pull-left mtop5"><?php echo _l('top_10_customer_payment'); ?></h4>
        <div class="clearfix"></div>
        <div class="row mtop5">
          <hr class="hr-panel-heading-dashboard">
        </div>

        <table class="table dataTable no-footer dtr-inline">
          <thead>
            <tr>
              <th><?= _l('company') ?></th>
              <th><?= _l('payment') ?></th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($widget_data)) { ?>
              <?php foreach ($widget_data as $row) { ?>
                <tr>
                  <td>
                    <a href="<?= admin_url('clients/client/' . (int)$row['userid']) ?>">
                      <?= html_escape($row['company']) ?>
                    </a>
                  </td>
                  <td class="priceable"><?= html_escape($row['totalpayment']) ?></td>
                </tr>
              <?php } ?>
            <?php } else { ?>
              <tr>
                <td colspan="2"><?= _l('not_found') ?></td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
