<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: New Customers
  Description: New Customers
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ الفترة من GET (قد تكون فاضية)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // دالة بارس آمنة
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) {
                return $dt;
            }
        }
        return new DateTime($fallbackSpec);
    };

    // Defaults: أول وآخر يوم في الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تأكيد الترتيب لو انعكسوا
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // استعلام آمن مع Bindings
    $sql = "
        SELECT
            COALESCE(NULLIF(company, ''), CONCAT('#', userid)) AS company,
            datecreated,
            userid
        FROM " . db_prefix() . "clients
        WHERE datecreated BETWEEN ? AND ?
        ORDER BY datecreated DESC
        LIMIT 10
    ";

    return $CI->db->query($sql, [$from_sql, $to_sql])->result_array();
};

$widget_data = $fn_get_data();
?>

<div class="widget widget-new-customers widget-<?= html_escape($widget['id']) ?>" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="">
    <div class="panel_s">
      <div class="panel-body">
        <div class="widget-dragger"></div>

        <h4 class="pull-left mtop5"><?php echo _l('top_10_new_customers'); ?></h4>
        <a href="<?php echo admin_url('clients'); ?>" class="pull-right mtop5"><?php echo _l('home_stats_full_report'); ?></a>
        <div class="clearfix"></div>
        <div class="row mtop5">
          <hr class="hr-panel-heading-dashboard">
        </div>

        <table class="table dataTable no-footer dtr-inline">
          <thead>
            <tr>
              <th><?= _l('company') ?></th>
              <th><?= _l('created_at') ?></th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($widget_data)) { ?>
              <?php foreach ($widget_data as $widget_row) { ?>
                <tr>
                  <td>
                    <a href="<?= admin_url('clients/client/' . (int)$widget_row['userid']) ?>">
                      <?= html_escape($widget_row['company']) ?>
                    </a>
                  </td>
                  <td><?= time_ago($widget_row['datecreated']) ?></td>
                </tr>
              <?php } ?>
            <?php } else { ?>
              <tr>
                <td colspan="2"><?= _l('not_found') ?></td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
