<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Total Customers
  Description: Total Customers
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ من الفترة (قد تكون فاضية)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // دالة بارس آمنة
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) {
                return $dt;
            }
        }
        return new DateTime($fallbackSpec);
    };

    // Defaults: أول وآخر يوم في الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تأكيد الترتيب لو انعكسوا
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // عدّ العملاء داخل الفترة باستخدام Bindings
    $sql = "
        SELECT COUNT(*) AS TOTAL_ROWS
        FROM " . db_prefix() . "clients c
        WHERE c.datecreated BETWEEN ? AND ?
    ";

    $res = $CI->db->query($sql, [$from_sql, $to_sql])->row_array();

    return [
        'TOTAL_ROWS' => isset($res['TOTAL_ROWS']) ? (int)$res['TOTAL_ROWS'] : 0,
    ];
};

$widget_data = $fn_get_data();
?>

<div class="widget widget-finance-total-orders widget-<?= html_escape($widget['id']) ?>" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="widget-dragger"></div>
  <div class="card-counter danger">
    <i class="fa fa-users"></i>
    <span class="count-numbers"><?= (int)$widget_data['TOTAL_ROWS'] ?></span>
    <span class="count-name"><?= _l('customers') ?></span>
  </div>
</div>
