<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Total income
  Description: Total income
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ الفترة من GET (قد تكون فاضية)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // دالة بارس آمنة ترجع DateTime حتى لو المدخل null/فاضي
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) {
                return $dt;
            }
        }
        return new DateTime($fallbackSpec);
    };

    // Defaults: أول وآخر يوم في الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تأكيد الترتيب لو انعكسوا
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // استعلام آمن مع Bindings
    $sql = "
        SELECT IFNULL(SUM(p.amount), 0) AS total_amount
        FROM " . db_prefix() . "invoicepaymentrecords p
        WHERE p.date BETWEEN ? AND ?
    ";

    $row = $CI->db->query($sql, [$from_sql, $to_sql])->row_array();

    return [
        'total_amount' => isset($row['total_amount']) ? (float)$row['total_amount'] : 0.0,
    ];
};

$widget_data = $fn_get_data();
?>

<div class="widget widget-finance-total-income" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="widget-dragger"></div>
  <div class="card-counter primary">
    <i class="fa fa-money"></i>
    <span class="count-numbers priceable"><?= html_escape($widget_data['total_amount']) ?></span>
    <span class="count-name"><?= _l('total_income') ?></span>
  </div>
</div>
