<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Total Revenue
  Description: Total Revenue
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ الفترة من GET (قد تكون فاضية)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // دالة بارس آمنة
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return new DateTime($fallbackSpec);
    };

    // Defaults: أول وآخر يوم في الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تأكيد الترتيب لو انعكسوا
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // اجمالي الإيراد من الفواتير "المدفوعة/مقبولة" status=2
    $sql = "
        SELECT IFNULL(SUM(inv.subtotal), 0) AS total_revenue
        FROM " . db_prefix() . "invoices inv
        WHERE inv.status = 2
          AND inv.date BETWEEN ? AND ?
    ";

    $row = $CI->db->query($sql, [$from_sql, $to_sql])->row_array();

    return [
        'total_revenue' => isset($row['total_revenue']) ? (float)$row['total_revenue'] : 0.0,
    ];
};

$widget_data = $fn_get_data();
?>

<div class="widget widget-total-revenue widget-<?= html_escape($widget['id']) ?>" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="">
    <div class="panel_s user-data">
      <div class="panel-body custom-dashboard-panel">
        <div class="widget-dragger"></div>

        <h4 class="pull-left mtop5"><?php echo _l('total_revenue'); ?></h4>
        <div class="clearfix"></div>
        <div class="row mtop5">
          <hr class="hr-panel-heading-dashboard">
        </div>

        <div class="revenue-labels">
          <div>
            <strong class="text-info priceable"><?= html_escape($widget_data['total_revenue']) ?></strong>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
