<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Lead by countries
  Description: Lead by countries
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ الفترة من GET (قد تكون فاضية)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // دالة بارس آمنة ترجع DateTime حتى لو المدخل null/فاضي
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return new DateTime($fallbackSpec);
    };

    // Defaults: أول وآخر يوم في الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تأكيد الترتيب لو انعكسوا
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // استعلام آمن مع Bindings
    $sql = "
        SELECT 
            c.country_id AS country_id,
            COALESCE(NULLIF(c.short_name, ''), '—') AS country_name,
            COUNT(*) AS total_leads
        FROM " . db_prefix() . "leads l
        INNER JOIN " . db_prefix() . "countries c
                ON l.country = c.country_id
        WHERE l.dateadded BETWEEN ? AND ?
        GROUP BY country_id, country_name
        ORDER BY total_leads DESC
        LIMIT 10
    ";

    $rows = $CI->db->query($sql, [$from_sql, $to_sql])->result_array();

    // بناء بيانات الرسم
    $labels = [];
    $data   = [];
    foreach ($rows as $r) {
        $labels[] = $r['country_name'];
        $data[]   = (int)$r['total_leads'];
    }

    return [
        'labels'   => $labels,
        'datasets' => [[
            'label'           => _l('leads'),
            'backgroundColor' => 'rgba(37,155,35,0.2)',
            'borderColor'     => '#84c529',
            'borderWidth'     => 1,
            'tension'         => false,
            'data'            => $data,
        ]],
    ];
};

$widget_data = $fn_get_data();
?>

<div class="widget widget-lead-by-countries" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="panel_s">
    <div class="panel-body">
      <div class="widget-dragger"></div>

      <h4 class="pull-left mtop5"><?php echo _l('lead_by_countries'); ?></h4>
      <div class="clearfix"></div>
      <div class="row mtop5">
        <hr class="hr-panel-heading-dashboard">
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="relative max-height-400">
            <canvas id="custom_dashboard_widget_<?= (int)$widget['id'] ?>_chart_data" class="animated fadeIn" height="400"></canvas>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  (function () {
    var wid = <?= (int)$widget['id'] ?>;
    window['custom_dashboard_widget_' + wid + '_chart_data'] =
      <?= json_encode($widget_data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>;
  })();
</script>
