<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Leads and converted leads by staff
  Description: Leads and converted leads by staff
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ الفترة من GET (قد تكون فاضية)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // دالة بارس آمنة
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return new DateTime($fallbackSpec);
    };

    // Defaults: أول وآخر يوم في الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تأكيد الترتيب لو انعكسوا
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // استعلام آمن: إجمالي Leads (dateadded) + إجمالي Converted (status=1, date_converted)
    $sql = "
    SELECT *
    FROM (
        SELECT
            s.staffid AS staff_id,
            CONCAT(s.firstname, ' ', s.lastname) AS staff_fullname,
            SUM(CASE WHEN l.id IS NOT NULL AND l.dateadded BETWEEN ? AND ? THEN 1 ELSE 0 END) AS total_leads,
            SUM(CASE WHEN l.status = 1 AND l.date_converted BETWEEN ? AND ? THEN 1 ELSE 0 END) AS total_converted_leads
        FROM " . db_prefix() . "staff s
        LEFT JOIN " . db_prefix() . "leads l
               ON l.assigned = s.staffid
        GROUP BY s.staffid, staff_fullname
    ) t
    WHERE (t.total_leads + t.total_converted_leads) > 0
    ORDER BY (t.total_leads + t.total_converted_leads) DESC
    LIMIT 10
";
$rows = $CI->db->query($sql, [$from_sql, $to_sql, $from_sql, $to_sql])->result_array();


    // جهّز بيانات الرسم
    $labels = [];
    $leads  = [];
    $conv   = [];

    foreach ($rows as $r) {
        $labels[] = $r['staff_fullname'];
        $leads[]  = (int)$r['total_leads'];
        $conv[]   = (int)$r['total_converted_leads'];
    }

    return [
        'labels'   => $labels,
        'datasets' => [
            [
                'label'           => _l('leads'),
                'backgroundColor' => 'rgba(37,155,35,0.2)',
                'borderColor'     => '#84c529',
                'borderWidth'     => 1,
                'tension'         => false,
                'data'            => $leads,
            ],
            [
                'label'           => _l('converted_leads'),
                'backgroundColor' => 'rgba(197, 61, 169, 0.5)',
                'borderColor'     => '#c53da9',
                'borderWidth'     => 1,
                'tension'         => false,
                'data'            => $conv,
            ],
        ],
    ];
};

$widget_data = $fn_get_data();
?>

<div class="widget widget-leads-and-converted-leads-by-staff" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="panel_s">
    <div class="panel-body">
      <div class="widget-dragger"></div>

      <h4 class="pull-left mtop5"><?php echo _l('leads_and_converted_leads_by_staff'); ?></h4>
      <div class="clearfix"></div>
      <div class="row mtop5">
        <hr class="hr-panel-heading-dashboard">
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="relative max-height-400">
            <canvas id="custom_dashboard_widget_<?= (int)$widget['id'] ?>_chart_data" class="animated fadeIn" height="400"></canvas>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  (function () {
    var wid = <?= (int)$widget['id'] ?>;
    window['custom_dashboard_widget_' + wid + '_chart_data'] =
      <?= json_encode($widget_data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>;
  })();
</script>
