<?php
defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Todos
  Description: Todos Description
*/
?>

<?php
$fn_get_todo_items = function ($finished, $page = '') {
    $CI = &get_instance();

    $CI->db->select();
    $CI->db->from(db_prefix() . 'todos');
    $CI->db->where('finished', (int)$finished);
    $CI->db->where('staffid', (int)get_staff_user_id());
    $CI->db->order_by('item_order', 'asc');

    if ($page !== '' && $CI->input->post('todo_page')) {
        $position = ((int)$page * 5);
        $CI->db->limit(5, $position);
    } else {
        $CI->db->limit(5);
    }

    $todos = $CI->db->get()->result_array();

    // format fields
    foreach ($todos as $i => $todo) {
        $todos[$i]['dateadded']    = _dt($todo['dateadded']);
        $todos[$i]['datefinished'] = _dt($todo['datefinished']);
        // description may contain links; keep intended HTML conversion
        $todos[$i]['description']  = check_for_links($todo['description']);
    }

    return $todos;
};

$todos          = $fn_get_todo_items(0);
$todos_finished = $fn_get_todo_items(1);

$widget_id_safe = isset($widget['id']) ? (int)$widget['id'] : 0;
?>

<div class="widget widget-todos widget-<?= html_escape($widget_id_safe) ?>" data-widget-id="<?= html_escape($widget_id_safe) ?>">
   <div class="panel_s todo-panel">
      <div class="panel-body padding-10">
         <div class="widget-dragger"></div>
         <p class="pull-left padding-5">
            <?php echo _l('home_my_todo_items'); ?>
         </p>
         <a href="<?php echo admin_url('todo'); ?>" class="pull-right padding-5">&nbsp;|&nbsp;<?php echo _l('home_widget_view_all'); ?></a>
         <a href="#__todo" data-toggle="modal" class="pull-right padding-5 padding-right-0">
            <?php echo _l('new_todo'); ?>
         </a>
         <div class="clearfix"></div>
         <hr class="hr-panel-heading-dashboard">

         <?php $total_todos = count($todos); ?>
         <h4 class="todo-title text-warning"><i class="fa fa-warning"></i> <?php echo _l('home_latest_todos'); ?></h4>
         <ul class="list-unstyled todo unfinished-todos todos-sortable sortable">
            <?php foreach ($todos as $todo): ?>
               <li>
                  <?php echo form_hidden('todo_order', (int)$todo['item_order']); ?>
                  <?php echo form_hidden('finished', 0); ?>
                  <div class="media">
                     <div class="media-left no-padding-right">
                        <div class="dragger todo-dragger"></div>
                        <div class="checkbox checkbox-default todo-checkbox">
                           <input type="checkbox" name="todo_id" value="<?= (int)$todo['todoid']; ?>">
                           <label></label>
                        </div>
                     </div>
                     <div class="media-body">
                        <p class="todo-description read-more no-padding-left" data-todo-description="<?= (int)$todo['todoid']; ?>">
                           <?= $todo['description']; // intentionally not escaped to allow links from check_for_links ?>
                        </p>
                        <a href="#" onclick="delete_todo_item(this,<?= (int)$todo['todoid']; ?>); return false;" class="pull-right text-muted">
                           <i class="fa fa-remove"></i>
                        </a>
                        <a href="#" onclick="edit_todo_item(<?= (int)$todo['todoid']; ?>); return false;" class="pull-right text-muted mright5">
                           <i class="fa fa-pencil"></i>
                        </a>
                        <small class="todo-date"><?= html_escape($todo['dateadded']); ?></small>
                     </div>
                  </div>
               </li>
            <?php endforeach; ?>
            <li class="padding no-todos ui-state-disabled <?= ($total_todos > 0 ? 'hide' : ''); ?>">
               <?php echo _l('home_no_latest_todos'); ?>
            </li>
         </ul>

         <?php $total_finished_todos = count($todos_finished); ?>
         <h4 class="todo-title text-success"><i class="fa fa-check"></i> <?php echo _l('home_latest_finished_todos'); ?></h4>
         <ul class="list-unstyled todo finished-todos todos-sortable sortable">
            <?php foreach ($todos_finished as $todo_finished): ?>
               <li>
                  <?php echo form_hidden('todo_order', (int)$todo_finished['item_order']); ?>
                  <?php echo form_hidden('finished', 1); ?>
                  <div class="media">
                     <div class="media-left no-padding-right">
                        <div class="dragger todo-dragger"></div>
                        <div class="checkbox checkbox-default todo-checkbox">
                           <input type="checkbox" value="<?= (int)$todo_finished['todoid']; ?>" name="todo_id" checked>
                           <label></label>
                        </div>
                     </div>
                     <div class="media-body">
                        <p class="todo-description read-more line-throught no-padding-left">
                           <?= $todo_finished['description']; // allow links ?>
                        </p>
                        <a href="#" onclick="delete_todo_item(this,<?= (int)$todo_finished['todoid']; ?>); return false;" class="pull-right text-muted">
                           <i class="fa fa-remove"></i>
                        </a>
                        <a href="#" onclick="edit_todo_item(<?= (int)$todo_finished['todoid']; ?>); return false;" class="pull-right text-muted mright5">
                           <i class="fa fa-pencil"></i>
                        </a>
                        <small class="todo-date todo-date-finished"><?= html_escape($todo_finished['datefinished']); ?></small>
                     </div>
                  </div>
               </li>
            <?php endforeach; ?>
            <li class="padding no-todos ui-state-disabled <?= ($total_finished_todos > 0 ? 'hide' : ''); ?>">
               <?php echo _l('home_no_finished_todos_found'); ?>
            </li>
         </ul>
      </div>
   </div>
   <?php $this->load->view('admin/todos/_todo.php'); ?>
</div>

<script>
  (function () {
    var wid = <?= $widget_id_safe ?>;
    window['custom_dashboard_widget_todos_' + wid + '_lang_read_more'] =
      <?= json_encode(_l('read_more'), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>;
    window['custom_dashboard_widget_todos_' + wid + '_lang_show_less'] =
      <?= json_encode(_l('show_less'), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>;
  })();
</script>
