<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Weekly Deadline Tasks
  Description: Weekly Deadline Tasks
*/
?>

<?php
// تحضير حالات المهام مرتبة
$fn_get_statuses = function () {
    $statuses = hooks()->apply_filters('before_get_task_statuses', [
        ['id'=>1,'color'=>'#989898','name'=>_l('task_status_1'),'order'=>1,'filter_default'=>true],
        ['id'=>4,'color'=>'#03A9F4','name'=>_l('task_status_4'),'order'=>2,'filter_default'=>true],
        ['id'=>3,'color'=>'#2d2d2d','name'=>_l('task_status_3'),'order'=>3,'filter_default'=>true],
        ['id'=>2,'color'=>'#adca65','name'=>_l('task_status_2'),'order'=>4,'filter_default'=>true],
        ['id'=>5,'color'=>'#84c529','name'=>_l('task_status_5'),'order'=>100,'filter_default'=>false],
    ]);
    usort($statuses, function ($a, $b) { return $a['order'] - $b['order']; });
    return $statuses;
};

$fn_get_data = function () use ($fn_get_statuses) {
    $CI = &get_instance();

    // قراءة الفترة من GET بشكل آمن (Y-m-d) مع ديفولت: الأسبوع الحالي
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return new DateTime($fallbackSpec);
    };

    // الأسبوع الحالي (الإثنين -> الأحد)
    $from_dt = $parse_date($from_raw, 'monday this week 00:00:00');
    $to_dt   = $parse_date($to_raw,   'sunday this week 23:59:59');

    // تصحيح الترتيب لو انعكس
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    // نحتاج مقارنة على تاريخ الاستحقاق (بدون وقت)
    $from_sql = $from_dt->format('Y-m-d');
    $to_sql   = $to_dt->format('Y-m-d');

    // خريطة أسماء الحالات
    $status_names = [];
    foreach ($fn_get_statuses() as $s) {
        $status_names[(int)$s['id']] = $s['name'];
    }

    // استعلام آمن
    $sql = "
        SELECT t.id, t.name, t.duedate, t.status
        FROM " . db_prefix() . "tasks t
        WHERE t.status <> 5
          AND t.duedate BETWEEN ? AND ?
        ORDER BY t.duedate ASC
        LIMIT 10
    ";
    $rows = $CI->db->query($sql, [$from_sql, $to_sql])->result_array();

    // تجهيز البيانات للعرض
    foreach ($rows as $i => $r) {
        $rows[$i]['status_name'] = isset($status_names[(int)$r['status']]) ? $status_names[(int)$r['status']] : _l('unknown');
        $rows[$i]['duedate_formatted'] = !empty($r['duedate']) && function_exists('_d') ? _d($r['duedate']) : $r['duedate'];
    }

    return $rows;
};

$widget_data    = $fn_get_data();
$widget_id_safe = isset($widget['id']) ? (int)$widget['id'] : 0;
?>

<div class="widget widget-weekly-deadline-tasks widget-<?= html_escape($widget_id_safe) ?>" data-widget-id="<?= html_escape($widget_id_safe) ?>">
  <div class="">
    <div class="panel_s user-data">
      <div class="panel-body custom-dashboard-panel">
        <div class="widget-dragger"></div>

        <h4 class="pull-left mtop5"><?php echo _l('task_to_deadline_this_week'); ?></h4>
        <div class="clearfix"></div>
        <div class="row mtop5">
          <hr class="hr-panel-heading-dashboard">
        </div>

        <table class="table dataTable no-footer dtr-inline">
          <thead>
            <th><?= _l('name') ?></th>
            <th><?= _l('status') ?></th>
            <th><?= _l('duedate') ?></th>
          </thead>
          <tbody>
            <?php if (!empty($widget_data)) : ?>
              <?php foreach ($widget_data as $row) : ?>
                <tr>
                  <td>
                    <a href="<?= admin_url('tasks/view/' . (int)$row['id']); ?>">
                      <?= html_escape($row['name']); ?>
                    </a>
                  </td>
                  <td><?= html_escape($row['status_name']); ?></td>
                  <td><?= html_escape($row['duedate_formatted']); ?></td>
                </tr>
              <?php endforeach; ?>
            <?php else : ?>
              <tr>
                <td colspan="3"><?= _l('not_found') ?></td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
