<?php
defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Logged hours by projects
  Description: Logged hours by projects
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ الفترة من GET بشكل آمن
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // بارس آمن مع fallback
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return new DateTime($fallbackSpec);
    };

    // الديفولت: أول وآخر يوم في الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تصحيح ترتيب التواريخ لو انعكس
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    // نفلتر حسب تاريخ التايمرز (start_time)
    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // استعلام آمن: احسب الساعات المُسجّلة لكل مشروع
    // يستخدم TIMESTAMPDIFF بالثواني ثم نقسم على 3600 ونأخذ FLOOR
    $sql = "
        SELECT
            p.id   AS project_id,
            p.name AS project_name,
            FLOOR(SUM(
                TIMESTAMPDIFF(
                    SECOND,
                    tmr.start_time,
                    COALESCE(tmr.end_time, NOW())
                )
            ) / 3600) AS total_logged_time
        FROM " . db_prefix() . "projects      p
        JOIN " . db_prefix() . "tasks         t   ON p.id = t.rel_id AND t.rel_type = 'project'
        JOIN " . db_prefix() . "taskstimers   tmr ON t.id = tmr.task_id
        WHERE tmr.start_time BETWEEN ? AND ?
        GROUP BY p.id, p.name
        HAVING total_logged_time > 0
        ORDER BY total_logged_time DESC
        LIMIT 10
    ";

    $rows = $CI->db->query($sql, [$from_sql, $to_sql])->result_array();

    // تجهيز بيانات الرسم
    $colors = get_system_favourite_colors();

    $chart = [
        'labels'   => [],
        'datasets' => [],
    ];

    $_data = [
        'data'                => [],
        'backgroundColor'     => [],
        'hoverBackgroundColor'=> [],
        'statusLink'          => [],
    ];

    foreach ($rows as $i => $r) {
        $hours = (int)$r['total_logged_time'];
        if ($hours <= 0) { continue; }

        $chart['labels'][]            = $r['project_name'];
        $_data['data'][]              = $hours;
        $_data['statusLink'][]        = admin_url('projects/view/' . (int)$r['project_id']);
        $_data['backgroundColor'][]   = $colors[$i % count($colors)];
        $_data['hoverBackgroundColor'][] = adjust_color_brightness($colors[$i % count($colors)], -20);
    }

    $chart['datasets'][] = $_data;

    return $chart;
};

$widget_data    = $fn_get_data();
$widget_id_safe = isset($widget['id']) ? (int)$widget['id'] : 0;
?>

<div class="widget widget-projects-logged-hours-by-projects widget-<?= html_escape($widget_id_safe) ?>" data-widget-id="<?= html_escape($widget_id_safe) ?>">
  <div class="row">
    <div class="col-md-12">
      <div class="panel_s">
        <div class="panel-body padding-10">
          <div class="widget-dragger"></div>

          <h4 class="pull-left mtop5"><?php echo _l('logged_hours_by_projects'); ?></h4>
          <div class="clearfix"></div>
          <div class="row mtop5">
            <hr class="hr-panel-heading-dashboard">
          </div>

          <?php
          $has_data = isset($widget_data['datasets'][0]['data']) && count($widget_data['datasets'][0]['data']) > 0;
          if ($has_data): ?>
            <div class="relative height-250">
              <canvas class="chart" height="250" id="chart-<?= html_escape($widget_id_safe) ?>"></canvas>
            </div>
          <?php else: ?>
            <p class="text-center"><?= _l('not_found') ?></p>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  (function () {
    // مرر البيانات للـ JS بأمان
    window['custom_dashboard_widget_<?= $widget_id_safe ?>_chart_data'] =
      <?= json_encode($widget_data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>;
  })();
</script>
