<?php
defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Logged hours by staff
  Description: Logged hours by staff
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // قراءة الفترة من GET بشكل آمن (Y-m-d) مع ديفولت: الشهر الحالي
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return new DateTime($fallbackSpec);
    };

    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تصحيح الترتيب لو انعكس
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    // فلترة حسب start_time للتايمرز
    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // احسب الساعات المُسجّلة لكل موظف فقط على مهام المشاريع
    $sql = "
        SELECT
            s.staffid AS staff_id,
            CONCAT(s.firstname, ' ', s.lastname) AS staff_fullname,
            FLOOR(SUM(
                TIMESTAMPDIFF(
                    SECOND,
                    tmr.start_time,
                    COALESCE(tmr.end_time, NOW())
                )
            ) / 3600) AS total_logged_time
        FROM " . db_prefix() . "staff s
        JOIN " . db_prefix() . "taskstimers tmr ON s.staffid = tmr.staff_id
        JOIN " . db_prefix() . "tasks t        ON t.id = tmr.task_id
        WHERE t.rel_type = 'project'
          AND tmr.start_time BETWEEN ? AND ?
        GROUP BY s.staffid, staff_fullname
        HAVING total_logged_time > 0
        ORDER BY total_logged_time DESC
        LIMIT 10
    ";

    $rows = $CI->db->query($sql, [$from_sql, $to_sql])->result_array();

    // تجهيز بيانات الرسم
    $colors = get_system_favourite_colors();

    $chart = [
        'labels'   => [],
        'datasets' => [],
    ];

    $_data = [
        'data'                 => [],
        'backgroundColor'      => [],
        'hoverBackgroundColor' => [],
        'statusLink'           => [],
    ];

    foreach ($rows as $i => $r) {
        $hours = (int)$r['total_logged_time'];
        if ($hours <= 0) { continue; }

        $chart['labels'][]              = $r['staff_fullname'];
        $_data['data'][]                = $hours;
        $_data['statusLink'][]          = 'javascript:void(0);'; // رابط تفصيلي إن رغبت لاحقًا
        $_data['backgroundColor'][]     = $colors[$i % count($colors)];
        $_data['hoverBackgroundColor'][]= adjust_color_brightness($colors[$i % count($colors)], -20);
    }

    $chart['datasets'][] = $_data;

    return $chart;
};

$widget_data    = $fn_get_data();
$widget_id_safe = isset($widget['id']) ? (int)$widget['id'] : 0;
?>

<div class="widget widget-projects-logged-hours-by-staff widget-<?= html_escape($widget_id_safe) ?>" data-widget-id="<?= html_escape($widget_id_safe) ?>">
  <div class="row">
    <div class="col-md-12">
      <div class="panel_s">
        <div class="panel-body padding-10">
          <div class="widget-dragger"></div>

          <h4 class="pull-left mtop5"><?php echo _l('logged_hours_by_staff'); ?></h4>
          <div class="clearfix"></div>
          <div class="row mtop5">
            <hr class="hr-panel-heading-dashboard">
          </div>

          <?php
          $has_data = isset($widget_data['datasets'][0]['data']) && count($widget_data['datasets'][0]['data']) > 0;
          if ($has_data): ?>
            <div class="relative height-250">
              <canvas class="chart" height="250" id="chart-<?= html_escape($widget_id_safe) ?>"></canvas>
            </div>
          <?php else: ?>
            <p class="text-center"><?= _l('not_found') ?></p>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  (function () {
    window['custom_dashboard_widget_<?= $widget_id_safe ?>_chart_data'] =
      <?= json_encode($widget_data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>;
  })();
</script>
