<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Total completed tasks
  Description: Total completed tasks
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // قراءة الفترة من GET بشكل آمن (Y-m-d) مع ديفولت: الشهر الحالي
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return new DateTime($fallbackSpec);
    };

    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تصحيح الترتيب إذا انعكس
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // احسب عدد المهام المكتملة (status = 5) المرتبطة بمشاريع فقط
    $sql = "
        SELECT COUNT(*) AS total_rows
        FROM " . db_prefix() . "tasks t
        WHERE t.status = 5
          AND t.rel_type = 'project'
          AND t.datefinished BETWEEN ? AND ?
    ";

    $row = $CI->db->query($sql, [$from_sql, $to_sql])->row_array();

    return [
        'total_rows' => isset($row['total_rows']) ? (int)$row['total_rows'] : 0,
    ];
};

$widget_data     = $fn_get_data();
$widget_id_safe  = isset($widget['id']) ? (int)$widget['id'] : 0;
$total_completed = (int)$widget_data['total_rows'];
?>

<div class="widget widget-projects-total-completed-tasks" data-widget-id="<?= html_escape($widget_id_safe) ?>">
  <div class="widget-dragger"></div>
  <div class="card-counter success">
    <i class="fa fa-check-square"></i>
    <span class="count-numbers"><?= $total_completed ?></span>
    <span class="count-name"><?= _l('completed_tasks') ?></span>
  </div>
</div>
