<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Top 20 staff income
  Description: Top 20 staff income
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // قراءة الفترة من GET مع ديفولت: الشهر الحالي
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return new DateTime($fallbackSpec);
    };

    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // الدخل محسوب من سجلات المدفوعات المنسوبة لوكيل البيع لكل فاتورة
    $sql = "
        SELECT
            CONCAT(s.firstname,' ',s.lastname) AS fullname,
            s.staffid AS staffid,
            IFNULL(SUM(p.amount), 0) AS totalincome
        FROM " . db_prefix() . "invoices i
        INNER JOIN " . db_prefix() . "staff s
                ON i.sale_agent = s.staffid
        INNER JOIN " . db_prefix() . "invoicepaymentrecords p
                ON i.id = p.invoiceid
               AND p.date BETWEEN ? AND ?
        GROUP BY s.staffid
        ORDER BY totalincome DESC
        LIMIT 0, 20
    ";

    return $CI->db->query($sql, [$from_sql, $to_sql])->result_array();
};

$widget_data    = $fn_get_data();
$widget_id_safe = isset($widget['id']) ? (int)$widget['id'] : 0;
?>

<div class="widget widget-top-20-staff-income widget-<?= html_escape($widget_id_safe) ?>" data-widget-id="<?= html_escape($widget_id_safe) ?>">
  <div class="">
    <div class="panel_s user-data">
      <div class="panel-body custom-dashboard-panel">
        <div class="widget-dragger"></div>

        <h4 class="pull-left mtop5"><?php echo _l('top_20_staff_income'); ?></h4>
        <div class="clearfix"></div>
        <div class="row mtop5">
          <hr class="hr-panel-heading-dashboard">
        </div>

        <table class="table dataTable no-footer dtr-inline">
          <thead>
            <th><?= _l('staff') ?></th>
            <th><?= _l('income') ?></th>
          </thead>
          <tbody>
            <?php if (!empty($widget_data)) { ?>
              <?php foreach ($widget_data as $row) { ?>
                <tr>
                  <td>
                    <a href="<?= admin_url('staff/member/' . (int)$row['staffid']) ?>">
                      <?= html_escape($row['fullname']) ?>
                    </a>
                  </td>
                  <td class="priceable"><?= (float)$row['totalincome'] ?></td>
                </tr>
              <?php } ?>
            <?php } else { ?>
              <tr>
                <td colspan="2"><?= _l('not_found') ?></td>
              </tr>
            <?php } ?>
          </tbody>
        </table>

      </div>
    </div>
  </div>
</div>
