<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'home_controller';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
$route['dashboard'] = 'author_dashboard';
$route['author-logout'] = 'author/logout';
$route['logout'] = 'author/logout';
$route['block-user/(:any)'] = 'author/block_user/$1';
$route['change-password'] = 'Author_dashboard/change_password';

// **************************************** admin*******************************************

$route['brand-list'] = 'author_master/brand_list';
$route['add-brand'] = 'author_master/add_brand';
$route['update-brand/(:any)'] = 'author_master/update_brand/$1';
$route['delete-brand/(:any)'] = 'author_master/delete_brand/$1';

$route['category-list'] = 'author_master/category_list';
$route['add-category'] = 'author_master/add_category';
$route['update-category/(:any)'] = 'author_master/update_category/$1';
$route['delete-category/(:any)'] = 'author_master/delete_category/$1';
$route['subcategory-list'] = 'author_master/subcategory_list';
$route['add-subcategory'] = 'author_master/add_subcategory';
$route['update-subcategory/(:any)'] = 'author_master/update_subcategory';
$route['delete-subcategory/(:any)'] = 'author_master/delete_subcategory';

$route['product-list'] = 'author_master/product_list';
$route['add-product'] = 'author_master/add_product';
$route['update-product/(:any)'] = 'author_master/update_product/$1';
$route['delete-product/(:any)'] = 'author_master/delete_product/$1';
$route['download-list'] = 'author_master/download_list';
$route['download-video/(:any)'] = 'author_master/download_video/$1';
$route['customer-list'] = 'author_master/customer_list';
$route['contactus-list'] = 'author_master/contactus_list';
$route['order-list'] = 'author_master/order_list';
$route['view-item/(:any)'] = 'author_master/view_item/$1';







// api sumanta code//

$route['brand'] = 'home_controller/brand';
$route['category-variation/(:any)'] = 'home_controller/category_variation/$1';
$route['category/(:any)/(:num)'] = 'home_controller/category/$1/$2';
$route['subcategory/(:any)'] = 'home_controller/subcategory/$1';
$route['gallery/(:any)'] = 'home_controller/gallery/$1';
$route['insert-cart'] = 'home_controller/insert_cart/';
$route['contact'] = 'home_controller/contact/';
$route['remove-cart/(:any)'] = 'home_controller/remove_cart/$1';
$route['insertorder-success'] = 'home_controller/insertorder_success';
$route['user-logout'] = 'home_controller/user_logout';












$route['all-product'] ='API/applecart_controller/all_product';
$route['random-productlist'] ='API/applecart_controller/random_product';
$route['view-single-product'] ='API/applecart_controller/view_single_product';
$route['add-wishlist'] ='API/applecart_controller/add_wishlist';
$route['view-wishlist'] ='API/applecart_controller/view_wishlist';
$route['delete-wishlist'] ='API/applecart_controller/delete_wishlist';
$route['delete-address'] ='API/applecart_controller/delete_address';

$route['add-address'] ='API/applecart_controller/add_address';
$route['api-update-address'] ='API/applecart_controller/update_address';
$route['view-address'] ='API/applecart_controller/view_address';
$route['insert-order'] ='API/applecart_controller/insert_order';
$route['order-histry'] ='API/applecart_controller/order_histry';
$route['coupon-view'] ='API/applecart_controller/coupon_list';
$route['apply-coupon'] ='API/applecart_controller/apply_coupon';
$route['api-order-update'] ='API/applecart_controller/api_order_update';
$route['api-view-profile'] ='API/register_controller/view_profile';
$route['api-update-profile'] ='API/register_controller/update_profile';
$route['add-review'] = 'API/applecart_controller/add_review';
$route['view-review'] = 'API/applecart_controller/view_review';
$route['view-pincode'] = 'API/applecart_controller/view_pincode';




 







































/* End Admin Route config */


                                 // Fronted route

$route['services'] = 'Gfc/services';


