<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Trusthub\V1\TrustProducts;

use Twilio\Deserialize;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * @property string $sid
 * @property string $trustProductSid
 * @property string $accountSid
 * @property string $objectSid
 * @property \DateTime $dateCreated
 * @property string $url
 */
class TrustProductsEntityAssignmentsInstance extends InstanceResource {
    /**
     * Initialize the TrustProductsEntityAssignmentsInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $trustProductSid The unique string that identifies the
     *                                TrustProduct resource.
     * @param string $sid The unique string that identifies the resource
     */
    public function __construct(Version $version, array $payload, string $trustProductSid, string $sid = null) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'sid' => Values::array_get($payload, 'sid'),
            'trustProductSid' => Values::array_get($payload, 'trust_product_sid'),
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'objectSid' => Values::array_get($payload, 'object_sid'),
            'dateCreated' => Deserialize::dateTime(Values::array_get($payload, 'date_created')),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = [
            'trustProductSid' => $trustProductSid,
            'sid' => $sid ?: $this->properties['sid'],
        ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return TrustProductsEntityAssignmentsContext Context for this
     *                                               TrustProductsEntityAssignmentsInstance
     */
    protected function proxy(): TrustProductsEntityAssignmentsContext {
        if (!$this->context) {
            $this->context = new TrustProductsEntityAssignmentsContext(
                $this->version,
                $this->solution['trustProductSid'],
                $this->solution['sid']
            );
        }

        return $this->context;
    }

    /**
     * Fetch the TrustProductsEntityAssignmentsInstance
     *
     * @return TrustProductsEntityAssignmentsInstance Fetched
     *                                                TrustProductsEntityAssignmentsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): TrustProductsEntityAssignmentsInstance {
        return $this->proxy()->fetch();
    }

    /**
     * Delete the TrustProductsEntityAssignmentsInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->proxy()->delete();
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Trusthub.V1.TrustProductsEntityAssignmentsInstance ' . \implode(' ', $context) . ']';
    }
}