<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Expense with categories
  Description: Expense with categories
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ الفترة من GET
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // دالة بارس آمنة
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) {
                return $dt;
            }
        }
        return new DateTime($fallbackSpec);
    };

    // Defaults: أول وآخر يوم في الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تأكيد الترتيب لو انعكسوا
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // ألوان النظام
    $colors = get_system_favourite_colors();

    // الاستعلام: LEFT JOIN مع فلترة التاريخ على سجل المصروفات
    // ملاحظة: WHERE على جدول LEFT JOIN بيحوّل الصفوف لداخلية لو مفيش مصروفات في الفترة،
    // وده مناسب لأننا أصلاً بنرشّح بـ HAVING total_amount > 0
    $sql = "
        SELECT 
            cat.id   AS category_id,
            cat.name AS category_name,
            SUM(
                IFNULL(exp.amount, 0)
              + IFNULL(exp.amount, 0) * (IFNULL(t1.taxrate, 0) / 100)
              + IFNULL(exp.amount, 0) * (IFNULL(t2.taxrate, 0) / 100)
            ) AS total_amount
        FROM " . db_prefix() . "expenses_categories cat
        LEFT JOIN " . db_prefix() . "expenses exp ON cat.id = exp.category
        LEFT JOIN " . db_prefix() . "taxes t1 ON exp.tax  = t1.id
        LEFT JOIN " . db_prefix() . "taxes t2 ON exp.tax2 = t2.id
        WHERE exp.date BETWEEN ? AND ?
        GROUP BY category_id, category_name
        HAVING total_amount > 0
        ORDER BY total_amount DESC
        LIMIT 10
    ";

    $rows = $CI->db->query($sql, [$from_sql, $to_sql])->result_array();

    // بناء بيانات الرسم
    $chart = [
        'labels'   => [],
        'datasets' => [],
    ];

    $_data = [
        'data'                => [],
        'backgroundColor'     => [],
        'hoverBackgroundColor'=> [],
        'statusLink'          => [],
    ];

    foreach ($rows as $i => $r) {
        $label = $r['category_name'] !== '' ? $r['category_name'] : '—';
        $val   = (float)round((float)$r['total_amount'], 2);

        $color = $colors[$i % count($colors)];
        $hover = adjust_color_brightness($color, -20);

        $chart['labels'][]           = $label;
        $_data['data'][]             = $val;
        $_data['backgroundColor'][]  = $color;
        $_data['hoverBackgroundColor'][] = $hover;
        $_data['statusLink'][]       = 'javascript:void(0);';
    }

    $chart['datasets'][] = $_data;

    return $chart;
};

$widget_data = $fn_get_data();
?>

<div class="widget widget-finance-expense-with-categories widget-<?= html_escape($widget['id']) ?>" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="row">
    <div class="col-md-12">
      <div class="panel_s">
        <div class="panel-body padding-10">
          <div class="widget-dragger"></div>

          <h4 class="pull-left mtop5"><?php echo _l('expense_with_categories'); ?></h4>
          <div class="clearfix"></div>
          <div class="row mtop5">
            <hr class="hr-panel-heading-dashboard">
          </div>

          <?php if (!empty($widget_data['datasets']) && !empty($widget_data['datasets'][0]['data'])) { ?>
            <div class="relative height-250">
              <canvas class="chart" height="250" id="chart-<?= html_escape($widget['id']) ?>"></canvas>
            </div>
          <?php } else { ?>
            <p class="text-center"><?= _l('not_found') ?></p>
          <?php } ?>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
  window['custom_dashboard_widget_<?= (int)$widget['id'] ?>_chart_data'] = <?= json_encode($widget_data, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) ?>;
</script>
