<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Monthly income and expense
  Description: Monthly income and expense
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ مدخلات الفترة (قد تكون فاضية)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // بارس آمن للتواريخ
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) return $dt;
        }
        return new DateTime($fallbackSpec);
    };

    $from_dt = $parse_date($from_raw, 'first day of January 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of December 23:59:59');

    // اختَر السنة
    if ($from_dt->format('Y') === $to_dt->format('Y')) {
        $year = (int)$from_dt->format('Y');
    } else {
        $year = (int)date('Y');
    }

    // مصفوفات الشهور
    $months_text = [
        'January','February','March','April','May','June',
        'July','August','September','October','November','December',
    ];
    $labels  = array_map(fn($m) => _l($m), $months_text);
    $income  = array_fill(0, 12, 0.0);
    $expense = array_fill(0, 12, 0.0);

    // استعلامات ب‍ Bindings (YEAR=?)
    $sql_income = "
        SELECT MONTH(p.date) AS m, SUM(p.amount) AS total_amount
        FROM " . db_prefix() . "invoicepaymentrecords p
        WHERE YEAR(p.date) = ?
        GROUP BY m
        ORDER BY m ASC
    ";

    $sql_expense = "
        SELECT MONTH(e.date) AS m,
               SUM(
                   e.amount
                 + e.amount * (IFNULL(t1.taxrate,0)/100)
                 + e.amount * (IFNULL(t2.taxrate,0)/100)
               ) AS total_amount
        FROM " . db_prefix() . "expenses e
        LEFT JOIN " . db_prefix() . "taxes t1 ON e.tax  = t1.id
        LEFT JOIN " . db_prefix() . "taxes t2 ON e.tax2 = t2.id
        WHERE YEAR(e.date) = ?
        GROUP BY m
        ORDER BY m ASC
    ";

    $rows_income  = $CI->db->query($sql_income, [$year])->result_array();
    $rows_expense = $CI->db->query($sql_expense, [$year])->result_array();

    foreach ($rows_income as $r) {
        $idx = max(1, min(12, (int)$r['m'])) - 1;
        $income[$idx] = (float)$r['total_amount'];
    }
    foreach ($rows_expense as $r) {
        $idx = max(1, min(12, (int)$r['m'])) - 1;
        $expense[$idx] = (float)$r['total_amount'];
    }

    // بيانات الرسم
    return [
        'labels'   => $labels,
        'datasets' => [
            [
                'label'           => _l('income'),
                'backgroundColor' => 'rgba(37,155,35,0.2)',
                'borderColor'     => '#84c529',
                'borderWidth'     => 1,
                'tension'         => false,
                'data'            => $income,
            ],
            [
                'label'           => _l('expense'),
                'backgroundColor' => 'rgba(197, 61, 169, 0.5)',
                'borderColor'     => '#c53da9',
                'borderWidth'     => 1,
                'tension'         => false,
                'data'            => $expense,
            ],
        ],
    ];
};

$widget_data = $fn_get_data();
?>

<div class="widget widget-finance-monthly-income-and-expense" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="panel_s">
    <div class="panel-body">
      <div class="widget-dragger"></div>

      <h4 class="pull-left mtop5"><?php echo _l('monthly_income_and_expense'); ?></h4>
      <div class="clearfix"></div>
      <div class="row mtop5">
        <hr class="hr-panel-heading-dashboard">
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="relative max-height-400">
            <canvas id="custom_dashboard_widget_<?= (int)$widget['id'] ?>_chart_data" class="animated fadeIn" height="400"></canvas>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  (function () {
    var wid = <?= (int)$widget['id'] ?>;
    window['custom_dashboard_widget_' + wid + '_chart_data'] =
      <?= json_encode($widget_data, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) ?>;
  })();
</script>
