<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Revenue top 10 with country
  Description: Revenue top 10 with country
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ الفترة من GET (قد تكون فاضية)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // دالة بارس آمنة
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) {
                return $dt;
            }
        }
        return new DateTime($fallbackSpec);
    };

    // Defaults: أول وآخر يوم في الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تأكيد الترتيب لو انعكسوا
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // استعلام آمن مع Bindings
    $sql = "
        SELECT 
            COUNT(inv.id)                         AS orders,
            SUM(inv.subtotal)                     AS total,
            COALESCE(NULLIF(c.short_name, ''), '—') AS country
        FROM " . db_prefix() . "invoices inv
        LEFT JOIN " . db_prefix() . "countries c
               ON inv.billing_country = c.country_id
        WHERE inv.status = 2
          AND inv.date BETWEEN ? AND ?
        GROUP BY inv.billing_country, country
        ORDER BY total DESC
        LIMIT 10
    ";

    return $CI->db->query($sql, [$from_sql, $to_sql])->result_array();
};

$widget_data = $fn_get_data();
?>

<div class="widget widget-revenue-top-10-with-country widget-<?= html_escape($widget['id']) ?>" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="">
    <div class="panel_s user-data">
      <div class="panel-body custom-dashboard-panel">
        <div class="widget-dragger"></div>

        <h4 class="pull-left mtop5"><?php echo _l('sale_by_countries'); ?></h4>
        <div class="clearfix"></div>
        <div class="row mtop5">
          <hr class="hr-panel-heading-dashboard">
        </div>

        <table class="table dataTable no-footer dtr-inline">
          <thead>
            <tr>
              <th><?= _l('country') ?></th>
              <th><?= _l('order') ?></th>
              <th><?= _l('revenue') ?></th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($widget_data)) { ?>
              <?php foreach ($widget_data as $row) { ?>
                <tr>
                  <td><?= html_escape($row['country']) ?></td>
                  <td class="order-num"><?= (int)$row['orders'] ?></td>
                  <td class="priceable"><?= html_escape($row['total']) ?></td>
                </tr>
              <?php } ?>
            <?php } else { ?>
              <tr>
                <td colspan="3"><?= _l('not_found') ?></td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
