<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Top 10 Selling Products
  Description: Top 10 Selling Products
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ الفترة من الـ GET (قد تكون فاضية)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // دالة بارس آمنة
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) {
                return $dt;
            }
        }
        return new DateTime($fallbackSpec);
    };

    // Defaults: أول وآخر يوم في الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تأكيد الترتيب إذا انعكسوا
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // ملاحظة: avg_unit_price = SUM(rate*qty)/SUM(qty)
    $sql = "
        SELECT
            it.description                                     AS description,
            SUM(it.qty)                                        AS quantity_sold,
            SUM(it.rate * it.qty)                              AS revenue,
            (SUM(it.rate * it.qty) / NULLIF(SUM(it.qty), 0))   AS avg_unit_price
        FROM " . db_prefix() . "itemable it
        JOIN " . db_prefix() . "invoices inv ON inv.id = it.rel_id
        WHERE it.rel_type = 'invoice'
          AND inv.status = 2
          AND inv.date >= ?
          AND inv.date <= ?
        GROUP BY it.description
        ORDER BY revenue DESC
        LIMIT 10
    ";

    return $CI->db->query($sql, [$from_sql, $to_sql])->result_array();
};

$widget_data = $fn_get_data();
?>
<div class="widget widget-top-10-selling-products widget-<?= html_escape($widget['id']) ?>" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="">
    <div class="panel_s">
      <div class="panel-body">
        <div class="widget-dragger"></div>

        <h4 class="pull-left mtop5"><?php echo _l('top_10_selling_products'); ?></h4>
        <div class="clearfix"></div>
        <div class="row mtop5">
          <hr class="hr-panel-heading-dashboard">
        </div>

        <table class="table dataTable no-footer dtr-inline">
          <thead>
            <tr>
              <th><?= _l('name') ?></th>
              <th><?= _l('avg_price') ?></th>
              <th><?= _l('sold') ?></th>
              <th><?= _l('revenue') ?></th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($widget_data)) { ?>
              <?php foreach ($widget_data as $row) { ?>
                <tr>
                  <td><?= html_escape($row['description']) ?></td>
                  <td class="priceable"><?= html_escape($row['avg_unit_price']) ?></td>
                  <td class="quantity-num"><?= (float)$row['quantity_sold'] ?></td>
                  <td class="priceable"><?= html_escape($row['revenue']) ?></td>
                </tr>
              <?php } ?>
            <?php } else { ?>
              <tr>
                <td colspan="4"><?= _l('not_found') ?></td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
