<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Total profit
  Description: Total profit
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ الفترة من GET (قد تكون فاضية)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // دالة بارس آمنة ترجع DateTime حتى لو المدخل null/فاضي
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) {
                return $dt;
            }
        }
        return new DateTime($fallbackSpec);
    };

    // Defaults: أول وآخر يوم في الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تأكيد الترتيب لو انعكسوا
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // ربح = مدفوعات العملاء - المصروفات (بما فيها الضرائب)
    $sql = "
        SELECT
            (
                SELECT IFNULL(SUM(p.amount), 0)
                FROM " . db_prefix() . "invoicepaymentrecords p
                WHERE p.date BETWEEN ? AND ?
            )
            -
            (
                SELECT IFNULL(SUM(
                    e.amount
                  + e.amount * (IFNULL(t1.taxrate, 0) / 100)
                  + e.amount * (IFNULL(t2.taxrate, 0) / 100)
                ), 0)
                FROM " . db_prefix() . "expenses e
                LEFT JOIN " . db_prefix() . "taxes t1 ON e.tax  = t1.id
                LEFT JOIN " . db_prefix() . "taxes t2 ON e.tax2 = t2.id
                WHERE e.date BETWEEN ? AND ?
            ) AS total_amount
    ";

    $row = $CI->db->query($sql, [$from_sql, $to_sql, $from_sql, $to_sql])->row_array();
    $profit = isset($row['total_amount']) ? (float)$row['total_amount'] : 0.0;

    return ['total_amount' => $profit];
};

$widget_data = $fn_get_data();
$profit = (float)$widget_data['total_amount'];
$is_negative = $profit < 0;
?>

<div class="widget widget-finance-total-profit" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="widget-dragger"></div>
  <div class="card-counter success">
    <i class="fa fa-money"></i>
    <span class="count-numbers priceable">
      <?= $is_negative ? '- ' : '' ?><span><?= html_escape(abs($profit)) ?></span>
    </span>
    <span class="count-name"><?= _l('total_profit') ?></span>
  </div>
</div>
