<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Lead by sources
  Description: Lead by sources
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ الفترة من GET (قد تكون فاضية)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    // دالة بارس آمنة
    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return new DateTime($fallbackSpec);
    };

    // Defaults: أول وآخر يوم في الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تأكيد الترتيب لو انعكسوا
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // استعلام آمن مع Bindings
    $sql = "
        SELECT 
            s.id AS source_id,
            COALESCE(NULLIF(s.name, ''), '—') AS source_name,
            COUNT(*) AS total_leads
        FROM " . db_prefix() . "leads l
        INNER JOIN " . db_prefix() . "leads_sources s
                ON l.source = s.id
        WHERE l.dateadded BETWEEN ? AND ?
        GROUP BY source_id, source_name
        ORDER BY total_leads DESC
        LIMIT 10
    ";

    $rows = $CI->db->query($sql, [$from_sql, $to_sql])->result_array();

    // ألوان النظام
    $colors = get_system_favourite_colors();

    // تجهيز بيانات الرسم
    $chart = [
        'labels'   => [],
        'datasets' => [],
    ];

    $_data = [
        'data'                => [],
        'backgroundColor'     => [],
        'hoverBackgroundColor'=> [],
        'statusLink'          => [],
    ];

    foreach ($rows as $i => $r) {
        $chart['labels'][] = $r['source_name'];
        $_data['data'][]   = (int)$r['total_leads'];

        $base  = $colors[$i % count($colors)];
        $_data['backgroundColor'][]      = $base;
        $_data['hoverBackgroundColor'][] = adjust_color_brightness($base, -20);
        $_data['statusLink'][]           = 'javascript:void(0);';
    }

    $chart['datasets'][] = $_data;

    return $chart;
};

$widget_data = $fn_get_data();
?>

<div class="widget widget-leads-lead-by-sources" data-widget-id="<?= html_escape($widget['id']) ?>">
  <div class="panel_s">
    <div class="panel-body">
      <div class="widget-dragger"></div>

      <h4 class="pull-left mtop5"><?php echo _l('lead_by_sources'); ?></h4>
      <div class="clearfix"></div>
      <div class="row mtop5">
        <hr class="hr-panel-heading-dashboard">
      </div>

      <div class="row">
        <div class="col-md-12">
          <?php if (!empty($widget_data['datasets']) && !empty($widget_data['datasets'][0]['data'])) { ?>
            <div class="relative height-250">
              <canvas class="chart" height="250" id="chart-<?= (int)$widget['id'] ?>"></canvas>
            </div>
          <?php } else { ?>
            <p class="text-center"><?= _l('not_found') ?></p>
          <?php } ?>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  (function () {
    var wid = <?= (int)$widget['id'] ?>;
    window['custom_dashboard_widget_' + wid + '_chart_data'] =
      <?= json_encode($widget_data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>;
  })();
</script>
