<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Calendar
  Description: Calendar Description
*/
?>

<?php
// تأمين بيانات الودجت
$widget_id_safe = isset($widget['id']) ? (int)$widget['id'] : 0;
$widget_safe    = $widget;
?>

<div class="widget widget-calendar widget-<?= html_escape($widget_id_safe) ?>" data-widget-id="<?= html_escape($widget_id_safe) ?>">
  <div class="clearfix"></div>
  <div class="panel_s">
    <div class="panel-body">
      <div class="widget-dragger"></div>
      <div class="dt-loader hide"></div>

      <?php
        // مرر نسخة مؤمنة من الودجت للجزئيات
        $this->load->view('custom_dashboard/partials/calendar_template', ['widget' => $widget_safe]);
        $this->load->view('custom_dashboard/partials/calendar_filters', ['widget' => $widget_safe]);
      ?>

      <div id="calendar-<?= html_escape($widget_id_safe) ?>"></div>
    </div>
  </div>
  <div class="clearfix"></div>
</div>

<script>
  (function () {
    var wid = <?= $widget_id_safe ?>;
    // متغير عام اختياري لو السكربتات تعتمد على id الودجت
    window['custom_dashboard_widget_' + wid + '_selector'] = '#calendar-' + wid;
    // لو عندك دالة تهيئة، هتلاقي السيليكتر جاهز:
    // if (typeof initCustomDashboardCalendar === 'function') {
    //   initCustomDashboardCalendar('#calendar-' + wid, { widgetId: wid });
    // }
  })();
</script>
