<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Projects Activity
  Description: Projects Activity
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    $id   = ''; // as in original
    $limit = hooks()->apply_filters('projects_activity_dashboard_limit', 20);

    // صلاحيات
    if (!is_client_logged_in()) {
        $has_permission = has_permission('projects', '', 'view');
        if (!$has_permission) {
            // وقّف على المشاريع التي المستخدم عضو فيها
            // نستخدم (int) لمنع الحقن داخل السطر
            $staff_id = (int) get_staff_user_id();
            $CI->db->where('project_id IN (SELECT project_id FROM ' . db_prefix() . 'project_members WHERE staff_id=' . $staff_id . ')', null, false);
        }
    } else {
        // العميل يرى فقط الأنشطة المعلنة للعميل
        $CI->db->where('visible_to_customer', 1);
    }

    if (is_numeric($id)) {
        $CI->db->where('project_id', (int)$id);
    }

    if (is_numeric($limit)) {
        $CI->db->limit((int)$limit);
    }

    $CI->db->order_by('dateadded', 'desc');
    $activities = $CI->db->get(db_prefix() . 'project_activity')->result_array();

    // تجهيز الحقول المعروضة
    foreach ($activities as $i => $activity) {
        $seconds          = get_string_between($activity['additional_data'], '<seconds>', '</seconds>');
        $other_lang_keys  = get_string_between($activity['additional_data'], '<lang>', '</lang>');
        $_additional_data = $activity['additional_data'];

        if ($seconds !== '') {
            $_additional_data = str_replace('<seconds>' . $seconds . '</seconds>', seconds_to_time_format($seconds), $_additional_data);
        }

        if ($other_lang_keys !== '') {
            $_additional_data = str_replace('<lang>' . $other_lang_keys . '</lang>', _l($other_lang_keys), $_additional_data);
        }

        if (strpos($_additional_data, 'project_status_') !== false) {
            $_status = get_project_status_by_id(strafter($_additional_data, 'project_status_'));
            if (isset($_status['name'])) {
                $_additional_data = $_status['name'];
            }
        }

        // ترجمة وصف الحدث
        $activities[$i]['description']     = _l($activities[$i]['description_key']);
        $activities[$i]['additional_data'] = $_additional_data;
        $activities[$i]['project_name']    = get_project_name_by_id($activity['project_id']);
        unset($activities[$i]['description_key']);
    }

    return $activities;
};

$widget_data = $fn_get_data();

// تحضير ID آمن للعرض
$widget_id_safe = isset($widget['id']) ? (int)$widget['id'] : 0;
$hidden_class = (count($widget_data) === 0) ? ' hide' : '';
?>

<div class="widget widget-projects-activity widget-<?= html_escape($widget_id_safe) ?><?= $hidden_class ?>" data-widget-id="<?= html_escape($widget_id_safe) ?>">
  <div class="panel_s projects-activity">
    <div class="panel-body padding-10">
      <div class="widget-dragger"></div>
      <p class="padding-5"><?php echo _l('home_project_activity'); ?></p>
      <hr class="hr-panel-heading-dashboard">
      <div class="activity-feed">
        <?php foreach ($widget_data as $activity): ?>
          <?php
            // إعداد الاسم والرابط بأمان
            $name = $activity['fullname'];
            $href = '';

            if (!empty($activity['staff_id'])) {
                $href = admin_url('profile/' . (int)$activity['staff_id']);
            } elseif (!empty($activity['contact_id'])) {
                $name = '<span class="label label-info inline-block mright5">' . _l('is_customer_indicator') . '</span> - ' . html_escape($name);
                $href = admin_url('clients/client/' . (int)get_user_id_by_contact_id($activity['contact_id']) . '?contactid=' . (int)$activity['contact_id']);
            } else {
                $name = '[CRON]';
            }

            $project_url  = admin_url('projects/view/' . (int)$activity['project_id']);
            $project_name = html_escape($activity['project_name']);
            $desc_text    = html_escape($activity['description']);
            // additional_data قد تحتوي نص مترجم / أسماء حالة — لو تحب تمنع HTML تماماً استخدم html_escape:
            $additional   = html_escape($activity['additional_data']);
          ?>
          <div class="feed-item">
            <div class="date">
              <span class="text-has-action" data-toggle="tooltip" data-title="<?php echo _dt($activity['dateadded']); ?>">
                <?php echo time_ago($activity['dateadded']); ?>
              </span>
            </div>
            <div class="text">
              <p class="bold no-mbot">
                <?php if ($href): ?>
                  <a href="<?php echo $href; ?>"><?= ($name === '[CRON]') ? $name : html_escape($name) ?></a> -
                <?php else: ?>
                  <?= ($name === '[CRON]') ? $name : html_escape($name) ?> -
                <?php endif; ?>
                <?= $desc_text ?>
              </p>
              <?php echo _l('project_name'); ?>:
              <a href="<?= $project_url; ?>"><?= $project_name; ?></a>
            </div>
            <?php if ($additional !== ''): ?>
              <p class="text-muted mtop5"><?= $additional; ?></p>
            <?php endif; ?>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</div>
