<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Project to deadline this month.
  Description: Project to deadline this month.
*/
?>

<?php
// جلب تعريفات الحالات وترتيبها
$fn_get_statuses = function () {
    $statuses = hooks()->apply_filters('before_get_project_statuses', [
        ['id'=>1,'color'=>'#989898','name'=>_l('project_status_1'),'order'=>1,'filter_default'=>true],
        ['id'=>2,'color'=>'#03a9f4','name'=>_l('project_status_2'),'order'=>2,'filter_default'=>true],
        ['id'=>3,'color'=>'#ff6f00','name'=>_l('project_status_3'),'order'=>3,'filter_default'=>true],
        ['id'=>4,'color'=>'#84c529','name'=>_l('project_status_4'),'order'=>100,'filter_default'=>false],
        ['id'=>5,'color'=>'#989898','name'=>_l('project_status_5'),'order'=>4,'filter_default'=>false],
    ]);
    usort($statuses, function ($a, $b) { return $a['order'] - $b['order']; });
    return $statuses;
};

$fn_get_data = function () use ($fn_get_statuses) {
    $CI = &get_instance();

    // قراءة الفترة من GET بشكل آمن
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return new DateTime($fallbackSpec);
    };

    // الديفولت: الشهر الحالي
    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تصحيح لو انعكس الترتيب
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // خريطة اسم الحالة
    $statuses = $fn_get_statuses();
    $status_names = [];
    foreach ($statuses as $s) {
        $status_names[(int)$s['id']] = $s['name'];
    }

    // استعلام آمن
    $sql = "
        SELECT p.id, p.name, p.deadline, p.status
        FROM " . db_prefix() . "projects p
        WHERE p.status <> 5
          AND p.deadline BETWEEN ? AND ?
        ORDER BY p.deadline ASC
        LIMIT 10
    ";
    $rows = $CI->db->query($sql, [$from_sql, $to_sql])->result_array();

    // تجهيز البيانات للعرض
    foreach ($rows as $i => $r) {
        $rows[$i]['status_name'] = isset($status_names[(int)$r['status']]) ? $status_names[(int)$r['status']] : _l('unknown');
        // صيغة التاريخ للعرض إن كانت الدالة متاحة
        if (!empty($r['deadline'])) {
            $rows[$i]['deadline_formatted'] = function_exists('_d') ? _d($r['deadline']) : $r['deadline'];
        } else {
            $rows[$i]['deadline_formatted'] = '';
        }
    }

    return $rows;
};

$widget_data   = $fn_get_data();
$widget_id_safe = isset($widget['id']) ? (int)$widget['id'] : 0;
?>

<div class="widget widget-monthly-deadline-projects widget-<?= html_escape($widget_id_safe) ?>" data-widget-id="<?= html_escape($widget_id_safe) ?>">
  <div class="">
    <div class="panel_s user-data">
      <div class="panel-body custom-dashboard-panel">
        <div class="widget-dragger"></div>

        <h4 class="pull-left mtop5"><?php echo _l('project_to_deadline_this_month'); ?></h4>
        <div class="clearfix"></div>
        <div class="row mtop5">
          <hr class="hr-panel-heading-dashboard">
        </div>

        <table class="table dataTable no-footer dtr-inline">
          <thead>
            <th><?= _l('name') ?></th>
            <th><?= _l('status') ?></th>
            <th><?= _l('deadline') ?></th>
          </thead>
          <tbody>
            <?php if (!empty($widget_data)) : ?>
              <?php foreach ($widget_data as $row) : ?>
                <tr>
                  <td>
                    <a href="<?= admin_url('projects/view/' . (int)$row['id']); ?>">
                      <?= html_escape($row['name']); ?>
                    </a>
                  </td>
                  <td><?= html_escape($row['status_name']); ?></td>
                  <td><?= html_escape($row['deadline_formatted']); ?></td>
                </tr>
              <?php endforeach; ?>
            <?php else : ?>
              <tr>
                <td colspan="3"><?= _l('not_found') ?></td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
