<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Total overdue tasks
  Description: Total overdue tasks
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // قراءة الفترة من GET بشكل آمن (Y-m-d)
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    $parse_date = function ($v) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return null; // لو مفيش فترة هنحسب المتأخرين حتى اليوم بدون أي فلترة إضافية
    };

    $from_dt = $parse_date($from_raw);
    $to_dt   = $parse_date($to_raw);

    // الاستعلام مع Bindings
    $params = [];
    $sql = "
        SELECT COUNT(*) AS total_rows
        FROM " . db_prefix() . "tasks t
        WHERE t.rel_type = 'project'
          AND t.status <> 5
          AND t.duedate IS NOT NULL
          AND t.duedate < CURDATE()
    ";

    // لو الفترة كاملة متوفرة فلتر duedate داخل الفترة
    if ($from_dt && $to_dt) {
        if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }
        $from_sql = $from_dt->format('Y-m-d 00:00:00');
        $to_sql   = $to_dt->format('Y-m-d 23:59:59');
        $sql     .= " AND t.duedate BETWEEN ? AND ? ";
        $params[] = $from_sql;
        $params[] = $to_sql;
    }

    $row = $CI->db->query($sql, $params)->row_array();

    return [
        'total_rows' => isset($row['total_rows']) ? (int)$row['total_rows'] : 0,
    ];
};

$widget_data     = $fn_get_data();
$widget_id_safe  = isset($widget['id']) ? (int)$widget['id'] : 0;
$total_overdue   = (int)$widget_data['total_rows'];
?>

<div class="widget widget-projects-total-overdue-tasks" data-widget-id="<?= html_escape($widget_id_safe) ?>">
  <div class="widget-dragger"></div>
  <div class="card-counter danger">
    <i class="fa fa-tasks"></i>
    <span class="count-numbers"><?= $total_overdue ?></span>
    <span class="count-name"><?= _l('overdue_tasks') ?></span>
  </div>
</div>
