<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Staff with departments
  Description: Staff with departments
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // قراءة الفترة من GET بشكل آمن (Y-m-d) مع ديفولت: الشهر الحالي
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return new DateTime($fallbackSpec);
    };

    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تصحيح الترتيب إذا انعكس
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // الاستعلام: نحافظ على LEFT JOIN مع فلتر التاريخ داخل شرط الربط
    $params = [];
    $sql = "
        SELECT 
            d.departmentid AS department_id,
            d.name         AS department_name,
            SUM(CASE WHEN s.staffid IS NOT NULL THEN 1 ELSE 0 END) AS total_staff
        FROM " . db_prefix() . "departments d
        LEFT JOIN " . db_prefix() . "staff_departments sd
               ON d.departmentid = sd.departmentid
        LEFT JOIN " . db_prefix() . "staff s
               ON sd.staffid = s.staffid
              AND s.datecreated BETWEEN ? AND ?
        GROUP BY department_id, department_name
        ORDER BY total_staff DESC
        LIMIT 0, 10
    ";
    $params[] = $from_sql;
    $params[] = $to_sql;

    $resultArray = $CI->db->query($sql, $params)->result_array();

    $colors = get_system_favourite_colors();

    $chart = [
        'labels'   => [],
        'datasets' => [],
    ];

    $_data = [
        'data'                => [],
        'backgroundColor'     => [],
        'hoverBackgroundColor'=> [],
        'statusLink'          => [],
    ];

    foreach ($resultArray as $idx => $row) {
        // اعرض الأقسام حتى لو 0 (لو عايز تخفي الصفر، فعّل الشرط التالي)
        // if ((int)$row['total_staff'] <= 0) { continue; }

        $chart['labels'][]            = $row['department_name'];
        $_data['backgroundColor'][]   = $colors[$idx % count($colors)];
        $_data['hoverBackgroundColor'][] = adjust_color_brightness($colors[$idx % count($colors)], -20);
        $_data['data'][]              = (int)$row['total_staff'];
        $_data['statusLink'][]        = 'javascript:void(0);';
    }

    $chart['datasets'][] = $_data;

    return $chart;
};

$widget_data    = $fn_get_data();
$widget_id_safe = isset($widget['id']) ? (int)$widget['id'] : 0;
?>

<div class="widget widget-staff-staff-with-departments" data-widget-id="<?= html_escape($widget_id_safe) ?>">
  <div class="row">
    <div class="col-md-12">
      <div class="panel_s">
        <div class="panel-body padding-10">
          <div class="widget-dragger"></div>

          <h4 class="pull-left mtop5"><?php echo _l('staff_with_departments'); ?></h4>
          <div class="clearfix"></div>
          <div class="row mtop5">
            <hr class="hr-panel-heading-dashboard">
          </div>
          <?php if (!empty($widget_data['datasets'][0]['data'])) { ?>
            <div class="relative height-250">
              <canvas class="chart" height="250" id="chart-<?= html_escape($widget_id_safe) ?>"></canvas>
            </div>
          <?php } else { ?>
            <p class="text-center"><?= _l('not_found') ?></p>
          <?php } ?>

        </div>
      </div>
    </div>
  </div>
</div>

<script>
  window['custom_dashboard_widget_<?= (int)$widget_id_safe ?>_chart_data'] = <?= json_encode($widget_data, JSON_HEX_TAG|JSON_HEX_AMP|JSON_HEX_APOS|JSON_HEX_QUOT) ?>;
</script>
