<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Staff with statuses
  Description: Staff with statuses
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // قراءة الفترة من GET (Y-m-d) مع ديفولت: الشهر الحالي
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    $parse_date = function ($v, $fallbackSpec) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return new DateTime($fallbackSpec);
    };

    $from_dt = $parse_date($from_raw, 'first day of this month 00:00:00');
    $to_dt   = $parse_date($to_raw,   'last day of this month 23:59:59');

    // تصحيح الترتيب لو انعكس
    if ($to_dt < $from_dt) { $tmp = $from_dt; $from_dt = $to_dt; $to_dt = $tmp; }

    $from_sql = $from_dt->format('Y-m-d 00:00:00');
    $to_sql   = $to_dt->format('Y-m-d 23:59:59');

    // المجموعات حسب حالة المهام؛ نبقي LEFT JOIN ونضع فلتر التاريخ داخل شرط الربط
    $sql = "
        SELECT 
            s.staffid AS staff_id,
            CONCAT(s.firstname, ' ', s.lastname) AS staff_fullname,
            SUM(CASE WHEN t.id IS NOT NULL THEN 1 ELSE 0 END)                                           AS total_tasks,
            SUM(CASE WHEN t.id IS NOT NULL AND t.status = 1 THEN 1 ELSE 0 END)                          AS not_started_tasks,
            SUM(CASE WHEN t.id IS NOT NULL AND t.status = 2 THEN 1 ELSE 0 END)                          AS awaiting_feedback_tasks,
            SUM(CASE WHEN t.id IS NOT NULL AND t.status = 3 THEN 1 ELSE 0 END)                          AS testing_tasks,
            SUM(CASE WHEN t.id IS NOT NULL AND t.status = 4 THEN 1 ELSE 0 END)                          AS in_progress_tasks,
            SUM(CASE WHEN t.id IS NOT NULL AND t.status = 5 THEN 1 ELSE 0 END)                          AS complete_tasks
        FROM " . db_prefix() . "staff s
        LEFT JOIN " . db_prefix() . "task_assigned ta
               ON s.staffid = ta.staffid
        LEFT JOIN " . db_prefix() . "tasks t
               ON ta.taskid = t.id
              AND t.dateadded BETWEEN ? AND ?
        GROUP BY s.staffid, staff_fullname
        ORDER BY total_tasks DESC
        LIMIT 0, 10
    ";

    return $CI->db->query($sql, [$from_sql, $to_sql])->result_array();
};

$widget_data    = $fn_get_data();
$widget_id_safe = isset($widget['id']) ? (int)$widget['id'] : 0;
?>

<div class="widget widget-staff-staff-with-statuses widget-<?= html_escape($widget_id_safe) ?>" data-widget-id="<?= html_escape($widget_id_safe) ?>">
  <div class="">
    <div class="panel_s">
      <div class="panel-body">
        <div class="widget-dragger"></div>

        <h4 class="pull-left mtop5"><?php echo _l('staff_with_statuses'); ?></h4>
        <div class="clearfix"></div>
        <div class="row mtop5">
          <hr class="hr-panel-heading-dashboard">
        </div>

        <table class="table dataTable no-footer dtr-inline">
          <thead>
            <th><?= _l('staff') ?></th>
            <th><?= _l('total_tasks') ?></th>
            <th><?= _l('task_status_1') ?></th>
            <th><?= _l('task_status_2') ?></th>
            <th><?= _l('task_status_3') ?></th>
            <th><?= _l('task_status_4') ?></th>
            <th><?= _l('task_status_5') ?></th>
          </thead>
          <tbody>
            <?php if (!empty($widget_data)) { ?>
              <?php foreach ($widget_data as $row) { ?>
                <tr>
                  <td><a href="<?= admin_url('staff/member/' . (int)$row['staff_id']) ?>"><?= html_escape($row['staff_fullname']) ?></a></td>
                  <td><?= (int)$row['total_tasks'] ?></td>
                  <td><?= (int)$row['not_started_tasks'] ?></td>
                  <td><?= (int)$row['awaiting_feedback_tasks'] ?></td>
                  <td><?= (int)$row['testing_tasks'] ?></td>
                  <td><?= (int)$row['in_progress_tasks'] ?></td>
                  <td><?= (int)$row['complete_tasks'] ?></td>
                </tr>
              <?php } ?>
            <?php } else { ?>
              <tr>
                <td colspan="7"><?= _l('not_found') ?></td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
