<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
  Widget Name: Total Staff
  Description: Total Staff
*/
?>

<?php
$fn_get_data = function () {
    $CI = &get_instance();

    // اقرأ التواريخ من GET مع دعم القيم الخالية بدون تحذيرات
    $from_raw = $CI->input->get('period_from');
    $to_raw   = $CI->input->get('period_to');

    $parse_date = function ($v) {
        if (is_string($v)) { $v = trim($v); }
        if (!empty($v)) {
            $dt = DateTime::createFromFormat('Y-m-d', $v);
            if ($dt instanceof DateTime) { return $dt; }
        }
        return null;
    };

    $from_dt = $parse_date($from_raw);
    $to_dt   = $parse_date($to_raw);

    $sql  = "SELECT COUNT(*) AS total_rows FROM " . db_prefix() . "staff TBLStaff";
    $bind = [];

    if ($from_dt !== null && $to_dt !== null) {
        // فلترة اليوم كاملًا
        $from_sql = $from_dt->format('Y-m-d 00:00:00');
        $to_sql   = $to_dt->format('Y-m-d 23:59:59');
        // تأكد أن from <= to
        if (strtotime($from_sql) > strtotime($to_sql)) {
            [$from_sql, $to_sql] = [$to_sql, $from_sql];
        }
        $sql  .= " WHERE TBLStaff.datecreated BETWEEN ? AND ?";
        $bind = [$from_sql, $to_sql];
    }

    return $CI->db->query($sql, $bind)->result_array();
};

$widget_data    = $fn_get_data();
$widget_id_safe = isset($widget['id']) ? (int)$widget['id'] : 0;
$total_rows     = isset($widget_data[0]['total_rows']) ? (int)$widget_data[0]['total_rows'] : 0;
?>

<div class="widget widget-finance-total-orders widget-<?= html_escape($widget_id_safe) ?>" data-widget-id="<?= html_escape($widget_id_safe) ?>">
  <div class="widget-dragger"></div>
  <div class="card-counter primary">
    <i class="fa fa-users"></i>
    <span class="count-numbers"><?= $total_rows ?></span>
    <span class="count-name"><?= _l('staff') ?></span>
  </div>
</div>
