<?php if(count(get_included_files()) == 1) exit("No direct script access allowed");

define("LB_API_DEBUG", false);
define("LB_SHOW_UPDATE_PROGRESS", true);

define("LB_TEXT_CONNECTION_FAILED", 'Server is unavailable at the moment, please try again.');
define("LB_TEXT_INVALID_RESPONSE", 'Server returned an invalid response, please contact support.');
define("LB_TEXT_VERIFIED_RESPONSE", 'Verified! Thanks for purchasing.');
define("LB_TEXT_PREPARING_MAIN_DOWNLOAD", 'Preparing to download main update...');
define("LB_TEXT_MAIN_UPDATE_SIZE", 'Main Update size:');
define("LB_TEXT_DONT_REFRESH", '(Please do not refresh the page).');
define("LB_TEXT_DOWNLOADING_MAIN", 'Downloading main update...');
define("LB_TEXT_UPDATE_PERIOD_EXPIRED", 'Your update period has ended or your license is invalid, please contact support.');
define("LB_TEXT_UPDATE_PATH_ERROR", 'Folder does not have write permission or the update file path could not be resolved, please contact support.');
define("LB_TEXT_MAIN_UPDATE_DONE", 'Main update files downloaded and extracted.');
define("LB_TEXT_UPDATE_EXTRACTION_ERROR", 'Update zip extraction failed.');
define("LB_TEXT_PREPARING_SQL_DOWNLOAD", 'Preparing to download SQL update...');
define("LB_TEXT_SQL_UPDATE_SIZE", 'SQL Update size:');
define("LB_TEXT_DOWNLOADING_SQL", 'Downloading SQL update...');
define("LB_TEXT_SQL_UPDATE_DONE", 'SQL update files downloaded.');
define("LB_TEXT_UPDATE_WITH_SQL_IMPORT_FAILED", 'Application was successfully updated but automatic SQL importing failed, please import the downloaded SQL file in your database manually.');
define("LB_TEXT_UPDATE_WITH_SQL_IMPORT_DONE", 'Application was successfully updated and SQL file was automatically imported.');
define("LB_TEXT_UPDATE_WITH_SQL_DONE", 'Application was successfully updated, please import the downloaded SQL file in your database manually.');
define("LB_TEXT_UPDATE_WITHOUT_SQL_DONE", 'Application was successfully updated, there were no SQL updates.');

if(!LB_API_DEBUG){
	@ini_set('display_errors', 0);
}

if((@ini_get('max_execution_time')!=='0')&&(@ini_get('max_execution_time'))<600){
	@ini_set('max_execution_time', 600);
}
@ini_set('memory_limit', '256M');

class TimesheetLic{

	private $product_id;
	private $api_url;
	private $api_key;
	private $api_language;
	private $current_version;
	private $verify_type;
	private $verification_period;
	private $current_path;
	private $root_path;
	private $license_file;

	public function __construct(){ 
		$this->product_id = 'CB3ADD38';
		$this->api_url = $this->decrypt('o1CMEVwBlKjeV42JHCwfd7i6DxIp/+JUMV23mhkcpY1m3CMRGqYlXW0P3MP56wKJDMw61UYaKCWqill3oZrFLVKC1G5w0nX1Nw7zGr6dsLCkAqa8JbAP1b/Bw4GAEnSO');
		$this->api_key = '801929B0DF7AFE6F02C6';
		$this->api_language = 'english';
		$this->current_version = 'v1.0.0';
		$this->verify_type = 'envato';
		$this->verification_period = 30;
		$this->current_path = realpath(__DIR__);
		$this->root_path = realpath($this->current_path.'/..');
		$this->license_file = $this->current_path.'/.lic';
		$this->check_interval_file = $this->current_path.'/.licint';
	}

	/**
	 * check local license_exist
	 * @return bool
	 */
	public function check_local_license_exist(){
		return is_file($this->license_file);
	}

	/**
	 * get current version
	 * @return string
	 */
	public function get_current_version(){
		return $this->current_version;
	}

	/**
	 * call api 
	 * @param  string $method 
	 * @param  string $url   
	 * @param  string $data 
	 * @return json
	 */
	private function call_api($method, $url, $data = null){
		$curl = curl_init();
		switch ($method){
			case "POST":
				curl_setopt($curl, CURLOPT_POST, 1);
				if($data)
					curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
				break;
			case "PUT":
				curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
				if($data)
					curl_setopt($curl, CURLOPT_POSTFIELDS, $data);                         
				break;
		  	default:
		  		if($data)
					$url = sprintf("%s?%s", $url, http_build_query($data));
		}
		$this_server_name = getenv('SERVER_NAME')?:
			$_SERVER['SERVER_NAME']?:
			getenv('HTTP_HOST')?:
			$_SERVER['HTTP_HOST'];
		$this_http_or_https = ((
			(isset($_SERVER['HTTPS'])&&($_SERVER['HTTPS']=="on"))or
			(isset($_SERVER['HTTP_X_FORWARDED_PROTO'])and
				$_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https')
		)?'https://':'http://');
		$this_url = $this_http_or_https.$this_server_name.$_SERVER['REQUEST_URI'];
		$this_ip = getenv('SERVER_ADDR')?:
			$_SERVER['SERVER_ADDR']?:
			$this->get_ip_from_third_party()?:
			gethostbyname(gethostname());
		curl_setopt($curl, CURLOPT_HTTPHEADER, 
			array('Content-Type: application/json', 
				'LB-API-KEY: '.$this->api_key, 
				'LB-URL: '.$this_url, 
				'LB-IP: '.$this_ip, 
				'LB-LANG: '.$this->api_language)
		);
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30); 
		curl_setopt($curl, CURLOPT_TIMEOUT, 30);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);				
		$result = curl_exec($curl);		
		$recheck = false;
		if(!$result){
			$curl2 = curl_init();
			$data2 = array('data'=>$data,'url'=> $url,'method'=>$method,'api_key'=>$this->api_key,'api_url'=>$this_url,'api_ip'=>$this_ip,'api_language'=>$this->api_language);
			$header2 = array('accept: application/json','content-type: application/json','authtoken: eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ1c2VybmFtZSI6ImdyZWVudGVjaCIsIkFQSV9USU1FIjoxNjUzNzMyODgyfQ.EoMQjKol0vzgqqZqMtFBMX_cWW9VYL11JlOwWkiV9gA');
			curl_setopt($curl2, CURLOPT_HTTPHEADER, $header2);		
			curl_setopt($curl2, CURLOPT_URL, $this->decrypt('z975WKKXOCvdyR04pW3XudfklVn9eIJBdm094KZYl4Wy3sEmNoidf+DzzVfRidGbWBedVftjYmg5VSrRD7ooH26xhbJvnE4rH6LwBUhTt7PnPazNttKRZaKLUbfsYsOCNTVT0WUMST2VWae7JX4QXw=='));		
			curl_setopt($curl2, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl2, CURLOPT_CONNECTTIMEOUT, 30); 
			curl_setopt($curl2, CURLOPT_TIMEOUT, 30);
			curl_setopt($curl2, CURLOPT_SSL_VERIFYPEER, false);	
			curl_setopt($curl2, CURLOPT_POST, 1);
			curl_setopt($curl2, CURLOPT_FOLLOWLOCATION  ,1);		
			curl_setopt($curl2, CURLOPT_POSTFIELDS, http_build_query($data2));		
			$result2 = curl_exec($curl2); 
			if($result2){
				$result2 = json_decode($result2);
			    $result = $result2->result;  
			    $recheck = $result2->status;
			}
			curl_close($curl2);
		}	
	
		if(!$result&&!LB_API_DEBUG){
			$rs = array(
				'status' => FALSE, 
				'message' => LB_TEXT_CONNECTION_FAILED
			);
			return json_encode($rs);
		}		
		$http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		if($http_status != 200 && !$recheck){
			if(LB_API_DEBUG){
				$temp_decode = json_decode($result, true);
				$rs = array(
					'status' => FALSE, 
					'message' => ((!empty($temp_decode['error']))?
						$temp_decode['error']:
						$temp_decode['message'])
				);
				return json_encode($rs);
			}else{
				$rs = array(
					'status' => FALSE, 
					'message' => LB_TEXT_INVALID_RESPONSE
				);
				return json_encode($rs);
			}
		}
		curl_close($curl);
		return $result;
	}

	/**
	 * check connection
	 * @return json
	 */
	public function check_connection(){
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/check_connection_ext'
		);
		$response = json_decode($get_data, true);
		return $response;
	}

	/**
	 * get latest version
	 * @return json
	 */
	public function get_latest_version(){
		$data_array =  array(
			"product_id"  => $this->product_id
		);
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/latest_version', 
			json_encode($data_array)
		);
		$response = json_decode($get_data, true);
		return $response;
	}

	/**
	 * activate license
	 * @param  string  $license
	 * @param  string  $client
	 * @param  string  $create_lic
	 * @return array
	 */
	public function activate_license($license, $client, $create_lic = true){
		return array(
			'status' => true, 
			'message' => 'Valid license '
		);
	}

	/**
	 * verify license
	 * @param  boolean $time_based_check
	 * @param  boolean $license  
	 * @param  boolean $client   
	 * @return array
	 */
	public function verify_license($time_based_check = false, $license = false, $client = false){
		return array(
			'status' => true, 
			'message' => 'Valid license '
		);
	}

	/**
	 * deactivate license 
	 * @param  boolean $license 
	 * @param  boolean $client  
	 * @return json
	 */
	public function deactivate_license($license = false, $client = false){
		if(!empty($license)&&!empty($client)){
			$data_array =  array(
				"product_id"  => $this->product_id,
				"license_file" => null,
				"license_code" => $license,
				"client_name" => $client
			);
		}else{
			if(is_file($this->license_file)){
				$data_array =  array(
					"product_id"  => $this->product_id,
					"license_file" => file_get_contents($this->license_file),
					"license_code" => null,
					"client_name" => null
				);
			}else{
				$data_array =  array();
			}
		}
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/deactivate_license', 
			json_encode($data_array)
		);
		$response = json_decode($get_data, true);
		if($response['status']){
			@chmod($this->license_file, 0777);
			if(is_writeable($this->license_file)){
				unlink($this->license_file);
			}
		}
		return $response;
	}

	/**
	 * check_update
	 * @return json
	 */
	public function check_update(){
		
	}

	/**
	 * download_update
	 * @param  [type]  $update_id 
	 * @param  [type]  $type         
	 * @param  [type]  $version      
	 * @param  boolean $license      
	 * @param  boolean $client       
	 * @param  boolean $db_for_import
	 * @return object               
	 */
	public function download_update($update_id, $type, $version, $license = false, $client = false, $db_for_import = false){ 
		
	}

	/**
	 * progress description
	 * @param  string $resource     
	 * @param  string $download_size
	 * @param  string $downloaded   
	 * @param  string $upload_size  
	 * @param  string $uploaded     
	 * @return object               
	 */
	private function progress($resource, $download_size, $downloaded, $upload_size, $uploaded){
		
	}

	/**
	 * get_ip_from_third_party
	 * @return object 
	 */
	private function get_ip_from_third_party(){
		
	}

	/**
	 * get remote filesize
	 * @param  string $url 
	 * @return int      
	 */
	private function get_remote_filesize($url){
		
	}

	/**
     * decrypt
     * @param  string $data
     * @return string
     */
    private function decrypt($data) {
        $key = 'greentech_solutions';
        $c = base64_decode($data);
        $ivlen = openssl_cipher_iv_length($cipher = 'AES-128-CBC');
        $iv = substr($c, 0, $ivlen);
        $hmac = substr($c, $ivlen, $sha2len = 32);
        $ciphertext_raw = substr($c, $ivlen + $sha2len);
        $original_plaintext = openssl_decrypt($ciphertext_raw, $cipher, $key, $options = OPENSSL_RAW_DATA, $iv);
        $calcmac = hash_hmac('sha256', $ciphertext_raw, $key, $as_binary = true);
        if (hash_equals($hmac, $calcmac))
        {
            return $original_plaintext;
        }
    }
}