<?php

/**
 * Ensures that the module init file can't be accessed directly, only within the application.
 */
defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: invoice_portal
Description:payment invoice portal.
Version: 2.3.0
Requires at least: 2.3.*
*/

/**
 * Register module language files to support custom_lang.php file
 * @param  string $module    module system name
 * @param  array  $languages array of language file names without the _lang.php
 * @return null
 */

register_language_files($module, $languages);

// register_language_files('woocommerce', ['woocommerce']);

$CI = &get_instance();
define('WOOCOMMERCE_MODULE_NAME', 'invoice_portal');
/**
 * Register module activation hook
 * @param  string $module   module system name
 * @param  mixed $function  function for the hook
 * @return mixed
 */

register_activation_hook($module, $function);
// register_activation_hook(WOOCOMMERCE_MODULE_NAME, 'woocommerce_activation_hook');



/**
 * Register module cron task, the cron task is executed after the core cron tasks are finished
 * @param  mixed $function  function/class parameter for the hook
 * @return null
 */

register_cron_task($function);



/**
 * Register module uninstall hook
 * @param  string $module   module system name
 * @param  mixed $function  function for the hook
 * @return mixed
 */

register_uninstall_hook($module, $function);

$CI->load->helper(WOOCOMMERCE_MODULE_NAME . '/invoice_portal');
$CI->load->helper(WOOCOMMERCE_MODULE_NAME . '/cron');

// register_cron_task('woocommerce_cron');


// hooks()->add_action('admin_init', 'woo_permissions');
// hooks()->add_action('app_admin_footer', 'woocommerce_load_js');
// hooks()->add_action('admin_init', 'woocommerce_init_menu_items');
// hooks()->add_filter('module_woocommerce_action_links', 'module_woocommerce_action_links');


hooks()->add_action($tag, $function_to_add, $priority = 10, $accepted_args = 1);
hooks()->add_filter($tag, $function_to_add, $priority = 10, $accepted_args = 1);
hooks()->do_action($tag, $arg = '');
hooks()->apply_filters($tag, $value, $additionalParams);


/**
 * Add additional settings for this module in the module list area
 * @param  array $actions current actions
 * @return array
 */
function module_woocommerce_action_links($actions)
{
    $actions[] = '<a href="' . admin_url('invoice_portal/stores') . '">' . _l('settings') . '</a>';
    $actions[] = '<a href="https://www.boxvibe.com/support?envato_item_id=25337376" target="_blank">' . _l('help') . '</a>';

    return $actions;
}
function woocommerce_activation_hook()
{
    require_once(__DIR__ . '/install.php');
}

/**
 * Injects chat Javascript
 * @return null
 */
function woocommerce_load_js()
{
    echo '<script src="' . module_dir_url('invoice_portal', 'assets/js/settings.js') . '"></script>';
}

function woocommerce_init_menu_items()
{
    if (has_permission('invoice_portal', '', 'view')) {

        $CI = &get_instance();
        $CI->app_menu->add_sidebar_menu_item('woocommerce-menu', [
            'name'     => 'invoice_portal', // The name if the item
            'collapse' => true, // Indicates that this item will have submitems
            'position' => 11, // The menu position
            'icon'     => 'fa fa-cart-plus', // Font awesome icon
        ]);
        $CI->app_menu->add_sidebar_children_item('woocommerce-menu', [
            'slug'     => 'woo-orders',
            'name'     => _l('orders'),
            'href'     => admin_url('invoice_portal/orders'),
            'position' => 11,
        ]);

        $CI->app_menu->add_sidebar_children_item('woocommerce-menu', [
            'slug'     => 'woo-customers',
            'name'     => _l('customers'),
            'href'     => admin_url('invoice_portal/customers'),
            'position' => 13,
        ]);
        $CI->app_menu->add_sidebar_children_item('woocommerce-menu', [
            'slug'     => 'woo-products',
            'name'     => _l('products'),
            'href'     => admin_url('invoice_portal/products'),
            'position' => 16,
        ]);
        if (is_admin()) {
            $CI->app_menu->add_sidebar_children_item('woocommerce-menu', [
                'slug'     => 'woo-products',
                'name'     => _l('stores'),
                'href'     => admin_url('invoice_portal/stores'),
                'position' => 18,
            ]);
        }
    }
}

function woo_permissions()
{
    $capabilities = [];
    $capabilities['capabilities'] = [
        'view'   => _l('permission_view') . '(' . _l('permission_global') . ')',
        'create' => _l('permission_create'),
        'edit'   => _l('permission_edit'),
        'delete' => _l('permission_delete'),
    ];
    register_staff_capabilities('invoice_portal', $capabilities, _l('invoice_portal'));
}



